function devices()
{
  var self = this;
  this.devices_obj = {};
  this.route = {};
  this.discovery_chron = {token: -1, devices: {}};
  this.chron_interval = "unset";

  this.add_device = function(new_device)
  {
    if(self.exists(new_device) == false) //exists since app start
    {
      //console.log("Adding device: " + JSON.stringify(new_device));
      self.devices_obj[new_device.ser_id] = new_device;
      self.route[new_device.id] = new_device.ser_id;  //this is for routing when modules change devices (dongle swapping)
      self.devices_obj[new_device.ser_id].config = new config(new_device.ser_id); //attach config to device
      self.devices_obj[new_device.ser_id].logs = new logs(new_device.ser_id); //attach config to device
      self.devices_obj[new_device.ser_id].connected = false;
      self.devices_obj[new_device.ser_id].mtu = undefined;

      self.devices_obj[new_device.ser_id].config.init()
        .then(function(e)
        {
          self.devices_obj[new_device.ser_id].logs.init(); //add logs object to new device
        });
    }
    else
    {
      console.log("Device already exists. Checking MAC route...");

      if(self.route[new_device.id] != new_device.ser_id)
      {
        self.route[new_device.id] = new_device.ser_id; //change to current route
        console.log("MAC route was changed");
      }
    }

    return new Promise(function(resolve){resolve()});
  }

  this.create_page = function(dev)
  {
    switch(this.devices_obj[dev.ser_id].name)
    {
      case "MNGP2": //if MNGP2
        this.devices_obj[dev.ser_id].device = new mngp2_device(self.devices_obj[dev.ser_id]); //create device page
        this.devices_obj[dev.ser_id].device.init(); //inialize device page
      break;
    }
  }

  this.disconnect_all = function()
  {
    var keys = Object.keys(this.devices_obj);

    for(var i = 0; i < keys.length; i++)
    {
      if(this.devices_obj[keys[i]].hasOwnProperty("connected"))
      {
        var ok = this.devices_obj[keys[i]];

        ble.isConnected(ok.id, function()
        {
          console.log("Is connected: " + ok.id);

          ble.disconnect(ok.id, function()
          {
            console.log("Forced Disconnect: " + ok.id);
          });
        });
      }
    }
  }

  this.exists = function(dev) //check to see if device already exists
  {
    if(dev != undefined && dev.hasOwnProperty("ser_id")) //we have an existing device
    {
      if(self.devices_obj[dev.ser_id] != undefined)
      {
        return true;
      }
    }

    return false;
  }

  this.get_config = function(ser_id)
  {
    return self.devices_obj[ser_id].config;
  }

  this.get_device = function(ser_id)
  {
    return this.devices_obj[ser_id];
  }

  this.add_property = function(dev_id, prop_id, prop)
  {
    this.devices_obj[dev_id][prop_id] = prop;
  }

  this.update_device_button = function(id, state)
  {
    if(state == true) //if we are updating connection state
    {
      //console.log("Update Device: " + JSON.stringify(this.devices_obj[id]));
      this.devices_obj[id].button.text("Connected: " + this.devices_obj[id].name + " ID: " + this.devices_obj[id].id);
    }
    else
    {
      //console.log("Devices: " + JSON.stringify(this.devices_obj[id]));
      this.devices_obj[id].button.text(this.devices_obj[id].name + " id: " + this.devices_obj[id].id);
    }
  }

  this.get_device_count = function()
  {
    return this.count;
  }

  this.get_connected = function(mac_id)
  {
    if(self.exists(self.devices_obj[self.route[mac_id]]))
    {
      if(self.devices_obj[self.route[mac_id]].connected)
      {
        return true;
      }
    }

    return false;
  }

  this.send_control = function(message) //this passes processed message from ble_module_control to device page
  {
    this.devices_obj[message.id].device.receive_control(message);
  }

  this.send_notification = function(id, data, type) //
  {
    if(type == "rx_spp")
    {
      this.devices_obj[self.route[id]].device.spp_in(data);
    }
    else if(type == "ble_control")
    {
      this.devices_obj[self.route[id]].device.control_in(data);
    }
    else if(type == "raw")
    {
      //console.log("send raw: " + id + " : " + data);
      //this.devices_obj[id].raw_in(data); //used to send before device detection
      if(this.discovery_chron.devices.hasOwnProperty(id))
      {
        this.discovery_chron.devices[id].discovery.raw_in(data);
      }
    }
  }

  this.send_status = function(ser_id, message)
  {
    if(typeof this.devices_obj[ser_id].device.receive_stream === "function" && ser_id != undefined)
    {
      this.devices_obj[ser_id].device.receive_stream(message);
    }
    else
    {
      console.log("STATUS: Page may not exist");
    }
  }

  this.set_mtu = function(ser_id, mtu)
  {
    if(self.devices_obj[ser_id].hasOwnProperty("mtu")) //mtu was set and device "page" exists
    {
      console.log("MTU: " + self.devices_obj[ser_id].mtu);
      self.devices_obj[ser_id].mtu = mtu;
    }
  }

  this.send_mtu = function(ser_id)
  {
    if(self.devices_obj[ser_id].hasOwnProperty("device"))
    {
      this.send_status(ser_id, {type: "mtu", value: self.devices_obj[ser_id].mtu});
    }
  }

  this.set_connected = function(ser_id, state)
  {
    console.log("set connected: " + ser_id + " state: " + state);

    self.devices_obj[ser_id].connected = state; //update device state

    if(self.devices_obj[ser_id].hasOwnProperty("device"))
    {
      this.send_status(ser_id, {type: "connection", connected: state});
    }
  } //end set Connected

  this.reset_discovery = function()
  {
    console.log("Reset discovery");
    this.discovery_chron.token = -1;
    this.discovery_chron.devices = {};

    if(this.chron_interval != "unset")
    {
      clearInterval(this.chron_interval);
    }

    this.chron_interval = "unset";
  }

  this.device_discovery = function(raw)
  {
    var raw_dev = raw;
    console.log("DEVICE: " + JSON.stringify(raw_dev));

    if(this.discovery_chron.devices[raw_dev.id] == undefined) //if device doesn't exist in chronological discovery object... add it
    {
      console.log("Adding device to discover: " + raw_dev.id);
      this.discovery_chron.devices[raw_dev.id] = raw_dev;
      this.discovery_chron.devices[raw_dev.id].timeout = 0;
      this.discovery_chron.devices[raw_dev.id].state = "undiscovered"; //country... was weird
      this.discovery_chron.devices[raw_dev.id].discovery = "undefined";
    }

    if(this.chron_interval == "unset" && (Object.keys(this.discovery_chron.devices).length >= 1)) //start
    {
      console.log("Starting discovery interval");
      this.chron_interval = setInterval(()=>
      {
        process_token();
      }, 500);
    }
  }

  function process_token() //don't assume this is called with token assigned
  {
    if(self.discovery_chron.token != -1) //make sure token is assigned to device id
    {
      if(self.discovery_chron.devices[self.discovery_chron.token].state == "undiscovered")
      {
        self.discovery_chron.devices[self.discovery_chron.token].timeout++;

        if(self.discovery_chron.devices[self.discovery_chron.token].timeout > 30) //timeout threshold reached
        {
          console.log("Device discovery timeout");
          self.discovery_chron.devices[self.discovery_chron.token].state = "attempted";
          self.discovery_chron.token = -1;
        }
        else //check state of device in discovery
        {
          if(self.discovery_chron.devices[self.discovery_chron.token].discovery != "undefined") //we are done with discovery on this device
          {
            if(self.discovery_chron.devices[self.discovery_chron.token].discovery.check_state())
            {
              console.log("Discovered device");
              self.discovery_chron.devices[self.discovery_chron.token].state = "discovered";
              delete self.discovery_chron.devices[self.discovery_chron.token].discovery;
              self.discovery_chron.token = -1;
            }
          }
        }
      }
    }
    else //if devices still undiscovered, run discovery on one
    {
      let keys = Object.keys(self.discovery_chron.devices);

      console.log("Devices: " + JSON.stringify(keys) + " : " + keys.length);

      for(let i = 0; i <= keys.length; i++) //get device to discover
      {
        if(i < keys.length && self.discovery_chron.devices[keys[i]].state == "undiscovered") //I guess just pick the first undiscovered... country
        {
          self.discovery_chron.token = self.discovery_chron.devices[keys[i]].id;
          self.discovery_chron.devices[keys[i]].discovery = new discovery(self.discovery_chron.devices[keys[i]]);
          self.discovery_chron.devices[keys[i]].discovery.init();
          break;
        }

        if(i == keys.length && i >= 1)
        {
          console.log("Interval cleared: " + i + " : " + self.chron_interval);
          clearInterval(self.chron_interval);
        }
      }
    }
  }
}//end devices
