var firmware_update =
{
  base_path: "http://www.midnitesolar.info/release/",
  parent: "undefined",
  device: "undefined",
  remote_device: "undefined",
  remote_bus_id: "undefined",
  this_bus_id: "undefined",
  device_version: "undefined",
  device_version_timeout: 5,
  device_filename_match: "undefined",
  firmware: "undefined",
  firmware_type: "undefined",
  firmware_version: "undefined",

  file_alias: {"30": "rosie", "2B": "hbay", "2C": "blna", "14": "mngp2", "0B": "combox", "2E": "classic", "2A": "b17mppt", "3C": "b17inv"},

  init: function(parent_in, device_in, this_bus_id_in, remote_device_in)
  {
    firmware_update.parent = parent_in;
    firmware_update.device = device_in;
    firmware_update.this_bus_id = this_bus_id_in;
    firmware_update.remote_device = remote_device_in;
    firmware_update.remote_bus_id = remote_device_in.bus_id;
    firmware_update.device_version = "undefined",
    firmware_update.device_version_timeout = 5,
    firmware_update.device_filename_match = firmware_update.file_alias[firmware_update.remote_device.device_type] + "_" +
     firmware_update.remote_device.variant_name + "_" + firmware_update.remote_device.spec + "_";
    firmware_update.firmware_type = "can";

    console.log("FIRMWARE UPDATE: " + firmware_update.device_filename_match + " : " + firmware_update.this_bus_id + " " + firmware_update.remote_bus_id);

    firmware_update.get_rev();
  },

  init_bt: function(device_name)
  {
    firmware_update.device_filename_match = device_name;
    firmware_update.firmware_type = "bt";
    firmware_update.device_version = "00000000";
    //firmware_update.check_local();
    firmware_update.check_remote();
  },

  get_rev: function()
  {
    if(firmware_update.device_version == "undefined" && firmware_update.device_version_timeout >= 1)
    {
      firmware_update.device_version_timeout--;

      if(firmware_update.device_version_timeout)
      {
        setTimeout(()=>{
          var frame = canbus.poll_register("3F9", firmware_update.remote_bus_id);
          console.log("GET REV: " + JSON.stringify(canbus.deconstruct_frame(frame)));
          ble_client.write_wo_response(firmware_update.device.id, spp.service, spp.tx, frame);
          firmware_update.get_rev();
        }, 500);
      }
    }
    else
    {
      if(firmware_update.device_version_timeout <= 0)
      {
        ons.notification.alert("UPDATE FAILED: Unable to get device firmware version.");
        firmware_update.end();
      }
      else
      {
        console.log("DEVICE VERSION IS: " + firmware_update.device_version);
        show_modal();
        update_modal("Checking local storage.");
        //firmware_update.check_local();
        firmware_update.check_remote();
      }
    }
  },

  check_local: function()
  {
    return new Promise((resolve)=>{
      file_management.get_local_dir_file_listing()
        .then((listing)=>{
          console.log("Listing: " + JSON.stringify(listing) + "\n" + JSON.stringify(firmware_update.remote_device));

          var newest = firmware_update.find_newest_firmware(listing);
          var time_stamp = 0;

          if(newest) //check for match
          {
            if(!newest.hasOwnProperty("old"))
            {
              time_stamp = parseInt(firmware_update.get_firmware_version(newest.name));
              resolve({"time_stamp": time_stamp, "newest": newest});
            }
            else //we have a match but not newest
            {
              resolve({"time_stamp": 0, "newest": newest});
            }
          }
          else
          {
            resolve(false);
          }
        });
    });
  },

  get_firmware_version: function(filename)
  {
    return filename.substring(firmware_update.device_filename_match.length, firmware_update.device_filename_match.length + 8);
  },

  get_nice_ver: function(version)
  {
    var ver = pad(version.toString().substring(0,2), 2) + "." + pad(version.toString().substring(2,4), 2) + "." + pad(version.toString().substring(4,6), 2) + "." + pad(version.toString().substring(6,8), 2);
    return ver;
  },

  check_remote: function() //this is main logic for picking files
  {
    update_modal("Checking update server.");

    file_management.load_firmware_map()
      .then((listing)=>{
        if(listing) //valid remote file
        {
          console.log("REMOTE FILES:" + JSON.stringify(listing));
          var newest = firmware_update.find_newest_firmware(listing);
          var newest_version = 0;

          if(!newest.hasOwnProperty("old")) //if valid newest
          {
            newest_version = parseInt(newest.name.substring(firmware_update.device_filename_match.length, firmware_update.device_filename_match.length + 8));
          }

          if(newest_version > firmware_update.device_version) //if remote newest is newer
          {
            firmware_update.check_local()
              .then((result)=>{

                console.log("CHECK LOCAL: " + JSON.stringify(result));
                update_modal("Checking local storage");

                if(result) //is valid local file
                {
                  var local = result;
                  console.log("LOCAL RETURNED: " + local.time_stamp + " FTP RETURNED: " + newest_version);

                  if(local.time_stamp >= newest_version)//if local matches remote and current... use local
                  {
                    firmware_update.firmware_version = local.time_stamp;
                    console.log("UPDATING FROM LOCAL WITH: " + local.newest.name);
                    firmware_update.update_firmware(local.newest.name);
                  }
                }

                if(!result || local.time_stamp < newest_version) // not newer or didn't return proper local search and remote check is good
                {
                    console.log("DOWNLOADING FROM REMOTE: " + newest.name);
                    firmware_update.get_firmware(newest.name); //download from remote and update
                }
              });
          }
          else if(newest_version <= firmware_update.device_version)
          {
            ons.notification.alert("You are running newest version: " + firmware_update.get_nice_ver(firmware_update.device_version));
            firmware_update.end();
          }
          else if(!newest) //less than case should not happen
          {
            ons.notification.alert("Error during file selection");
            firmware_update.end();
          }
        }
        else if(!listing) //remote failed to connnect, or list
        {
          firmware_update.check_local()
            .then((result)=>{
              console.log("CHECK LOCAL: " + JSON.stringify(result));

              if(result) //is valid local file
              {
                if(result.time_stamp <= firmware_update.device_version)
                {
                  ons.notification.alert("You are running newest version: " + firmware_update.get_nice_ver(firmware_update.device_version));
                  firmware_update.end();
                }
                if(result.time_stamp > firmware_update.device_version) //if local is newer than current
                {
                  firmware_update.firmware_version = result.time_stamp;
                  console.log("UPDATING WITH: " + result.newest.name);
                  firmware_update.update_firmware(result.newest.name);
                }
                else if(!result)
                {
                  ons.notification.alert("Error during file selection");
                  firmware_update.end();
                }
              }
              else
              {
                ons.notification.alert("Failed to connect to update server. Check internet or try again later.");
                firmware_update.end();
              }
            });
        }
      }); //ftp list
  },

  update_firmware: function(filename)
  {
    file_management.read_local_file(filename, "text")
      .then((result)=>{
        if(result) //convert to useable format
        {
          firmware_update.firmware = result.data.target._result
          firmware_update.firmware = local_to_arr8(JSON.parse(firmware_update.firmware));
        }
      }).then(()=>{

          if(firmware_update.firmware_type == "can")
          {
            let nice_version = firmware_update.get_nice_ver(firmware_update.firmware_version);

            ons.notification.confirm({message: 'Would you like to update the ' + canbus_map.device_types[firmware_update.remote_device.device_type] + ' to version: ' + nice_version + '? </br> (WARNING! Device may power down during update and reset configuration data)', cancelable: true, title: 'Update', buttonLabels: ['Ok', 'Cancel'], primaryButtonIndex: 0})
              .then((button)=>{

                if(button == 0)
                {
                  ble_client.filter_packet(firmware_update.device, firmware_update.this_bus_id); //start update at receive stream
                }
                else
                {
                  firmware_update.end();
                }
              });
          }
          else if(firmware_update.firmware_type == "bt")
          {
            ota_update.set_firmware(firmware_update.firmware);
          }
        });

      console.log("UPDATING: " + JSON.stringify(filename));
  },

  find_newest_firmware: function(listing)
  {
    let newer = 0;
    let match = false;

    for(let i = 0; i < listing.length; i++) //run through local and check for newer
    {
      if(listing[i].name.length >= firmware_update.device_filename_match.length + 11) //saftey for parseInt when name is too short
      {
        let truncated = listing[i].name.substring(0, firmware_update.device_filename_match.length);

        if(truncated == firmware_update.device_filename_match)
        {
          let list_date = parseInt(listing[i].name.substring(truncated.length, firmware_update.device_filename_match.length + 8));
          match = listing[i];
          console.log("MATCH: " + JSON.stringify(match));
          if(isNaN(list_date))
          {
            console.log("NEWEST ERROR: " + JSON.stringify(listing[i]));
          }
          else
          {
            if(list_date >= firmware_update.device_version) //check for up to date, then...
            {
              if(newer == 0) //check first newer
              {
                newer = listing[i];
              }
              else if(list_date >= (parseInt(newer.name.substring(firmware_update.device_filename_match.length, firmware_update.device_filename_match.length + 8)))) //check newer against current
              {
                newer = listing[i];
              }
            }
          }
        } // is match
      }
    }

    var newest = "";

    if(newer != 0)
    {
      newest = newer;
      console.log("FOUND NEWEST: " + JSON.stringify(newest));
      return newest;
    }
    else if(match)
    {
      console.log("FOUND NOT NEWEST");
      match.old = true;
      newest = match;
      return newest;
    }
    else
    {
      console.log("SEARCH ERROR: " + JSON.stringify(newest));
      hide_modal();
      return false;
    }
  },

  find_oldest: function(listing, file_name_match)
  {
    let older = 0;
    let match_count = 0;

    console.log("OLDEST MATCH: " + file_name_match);

    for(let i = 0; i < listing.length; i++) //run through local and check for newer
    {
      if(listing[i].name.length >= file_name_match.length + 11) //saftey for parseInt when name is too short
      {
        let truncated = listing[i].name.substring(0, file_name_match.length);

        if(truncated.toUpperCase() == file_name_match.toUpperCase()) //found match
        {
          match_count++;

          let list_date = parseInt(listing[i].name.substring(truncated.length, file_name_match.length + 8));

            if(older == 0) //check first newer
            {
              older = listing[i];
            }
            else if(list_date < (parseInt(older.name.substring(file_name_match.length, file_name_match.length + 8)))) //check newer against current
            {
              older = listing[i];
              console.log("Older: " + JSON.stringify(older));
            }
          }
        }
      }

    if(older != 0 && match_count >= 2)
    {
      var oldest = older;
      return oldest;
    }
    else
    {
      return false;
    }
  },

  delete_oldest: function(name)
  {
    var match_name = name;

    return new Promise((resolve)=>{
      file_management.get_local_dir_file_listing()
        .then((listing)=>{

          var file = firmware_update.find_oldest(listing, match_name);

          console.log("DELETE OLDEST: " + JSON.stringify(file));

          if(file)
          {
            file_management.delete_local(file)
              .then(()=>{
                resolve(true);
              });
          }
          else
          {
            console.log("NOTHING TO DELETE");
            resolve(false);
          }
        });
      });
  },

  get_firmware: function(filename) //Down
  {
    return new Promise((resolve)=>
    {
      file_management.download_file(firmware_update.base_path + filename, filename, "arraybuffer") //download and save to local
        .then((result)=>
        {
          if(result != false)
          {
            firmware_update.delete_oldest(firmware_update.device_filename_match)
              .then(()=>{
                   firmware_update.firmware_version = firmware_update.get_firmware_version(filename);
                   firmware_update.update_firmware(filename);
              });
          }
          else
          {
            alert("Failed to download firmware. Check internet connection and try again.");
            firmware_update.end();
          }
        });
    });
  },

  receive_stream: function(message_in)
  {
    var message = message_in;

    if(message.type == "filter") //start transfer
    {
      firmware_update.parent.set_stream_location.call(firmware_update.parent, "file_transfer");
      file_transfer.init(firmware_update.device, firmware_update.this_bus_id, firmware_update.remote_bus_id, firmware_update.remote_device, firmware_update.firmware);
    }

    if(message.bus_id == firmware_update.remote_bus_id)
    {
      switch(message.register)
      {
        case "3F9":
          let year = parseInt(message.data.substring(0,2),16).toString();
          let month = pad(parseInt(message.data.substring(2,4),16).toString(), 2);
          let day = pad(parseInt(message.data.substring(4,6),16).toString(), 2);
          let debug = pad(parseInt(message.data.substring(6),16).toString(), 2);

          if(debug.length >= 3) //values over 100
          {
            debug = debug.substring(0,2);
          }

          firmware_update.device_version = parseInt(year + month + day + debug);
          clearInterval(firmware_update.device_firmware_timeout);
          console.log("DEVICE VERSION: " + firmware_update.device_version + " " + "HOST DATA: " + JSON.stringify(message) + " ID: " + message.bus_id);
        break;
      }
    }
  },

  download_all_firmware: function(device_list)
  {
    ftp_client.get_list("/")
      .then((listing)=>{
        if(listing) //valid remote file
        {
          for(let i = 0; i < device_list.length; i++)
          {

          }
        }
      });
  },

  end: function()
  {
    console.log("Calling END!");
    firmware_update.parent.set_stream_location.call(firmware_update.parent, "mngp2"); //go back to system level
    hide_modal();
  }
}
