 var ota_page =
 {
    device: "undefined",
    page: "undefined",
    alert_dialog: undefined,

    init: function(device_in)
    {
      ota_page.device = device_in;

      //console.log("Update device: " + JSON.stringify(ota_page.device));
      ota_page.page = $("#update_status");
      ota_page.alert_dialog = undefined;

      ons_createAttach("<div><label id='progress_" + ota_page.device.ser_id + "'>&nbsp;</label></div>", ota_page.page);
      ons_createAttach("<div><label id='state_" + ota_page.device.ser_id + "'></label></div>", ota_page.page);

      ota_page.add_events();
      ota_update.init(ota_page.device, ota_page.page);
    },

    update_progress: function(progress)
    {
      $("#progress_" + ota_page.device.ser_id).text(progress);

      var num = parseInt(progress.substring(0,2));

      if(progress == "100%")//we are done... lets add ok button
      {
        ble.refreshDeviceCache(ota_update.device.id, 1500, function()
        {
          console.log("Refreshed: " + ota_update.device.id);
        });

        var target = $("#cancel_update");
        $("#update_progress_bar").attr("value", 100);
        target.text("ok");
      }
      else if (num < 100)
      {
        $("#update_progress_bar").attr("value", num);
      }
    },

    update_ui: function(state)
    {
      $("#state_" + ota_page.device.ser_id).text(state);
    },

    update_rssi: function(rssi)
    {
      $("rssi_" + ota_page.device.ser_id).text(rssi);
    },

    add_events: function()
    {
      $("#update_ble_dialog").one("prehide", ()=>
      {
        if($("#generic_dialog").length > 0) //think other uses of generic dialog... I came back to this many months later, so....
        {
          $("#generic_dialog").empty();
        }

        $("#update_ble_dialog").remove();
      });

      $("#cancel_update").on("click", ()=>
      {
        var text = $("#cancel_update").text();

        if(text == "ok") //done with update
        {

          ota_page.remove_ble_dialog();
        }
        else //CANCEL DIALOG ****************************************
        {
          if($("#generic_dialog").length > 0)
          {
            $("#generic_dialog").remove();
          }

          nav.dialog()
            .then(function()
            {
              ons.notification.confirm({message: "Canceling update will probably make device inoperable.<br>Do you wish to continue?", cancelable: true, title: "Cancel Update", buttonLabels: ["Cancel", "Ok"], primaryButtonIndex: 0})
                .then((button)=>{

                  if(button == 1)
                  {
                    ota_update.kill_update();
                  }
                });
            });
          }//else
        });
    },

    remove_ble_dialog: function()
    {
      if($("#update_ble_dialog").length > 0)
      {
        $("#update_ble_dialog").remove();
        $("#update_ble_dialog").off();
      }

      ble.isConnected(ota_page.device.id, function()
      {
        ble.disconnect(ota_page.device.id);
      });

      nav.home();
    },
}
