var ota_update =
{
  device_name: "mngp2_bt_",
  update_ui: {state:"get_file", reason: ""},
  file_threshold: {attempts:3, timeout: 1500},
  connection_threshold: {attempts: 3, timeout: 3000},
  dfu_threshold: {attempts:2, timeout: 2500},
  ota_byte_threshold: {attempts: 3, timeout: 1500},
  ota_scan_threshold:{attempts: 1, timeout: 3500},
  ota_mtu_threshold: {attempts: 1, timeout: 1500},
  transfer_threshold: {attempts:1, timeout:1500},
  update_attempts: 0,

  firmware: undefined,
  device: undefined,
  mtu: 0,
  process_interval: undefined,

  timeout: "undefined",
  time_keeper: 0,
  attempts: 0,
  in_scan: false,
  response: false,
  kill: 0,
  in_update: false,

  init: function(dev) //dev is device instance, and prod is the progress dialog context
  {
    ota_update.stop_process_interval();

    ota_update.update_ui.state = "get_file";
    ota_update.device = dev;
    ota_update.firmware = "undefined";
    ota_update.time_keeper = 0;
    ota_update.attempts = 0;
    ota_update.in_scan = false;
    ota_update.response = false;
    ota_update.mtu = 20;
    ota_update.kill = 0;
    ota_update.update_attempts = 0;
    ota_update.in_update = true;
    ota_update.timeout = "undefined";

    console.log("Start Update:" + dev.id);
    ota_update.process_update_modes();
  },

  end_update: function()
  {
    ota_update.in_update = false;
    ota_update.stop_process_interval();
    ota_page.remove_ble_dialog();
  },

  stop_process_interval: function()
  {
    if(ota_update.process_interval)
    {
      clearInterval(ota_update.process_interval);
      ota_update.process_interval = "undefined";
    }
  },

  start_process_interval: function(state)
  {
    var process_state = state;

    if(ota_update.process_interval)
    {
      clearInterval(ota_update.process_interval);
      ota_update.update_ui.state = process_state;
      ota_update.process_update_modes();
    }
  },

  get_firmware: function()
  {
    firmware_update.init_bt(ota_update.device_name);
  },

  set_firmware: function(firmware)
  {
    ota_update.firmware = firmware;
    ota_page.update_ui("Firmware: " + (ota_update.firmware.length / 1000) + "K");
    ota_update.update_ui.state = "get_connected";
    ota_update.ota_reset();
  },

  receive_input: function(message_in) //dialog return become firmware type to update
  {
    console.log("Value returned from update dialog: " + JSON.stringify(message_in));

    if(message_in.new_value == "cancel")
    {
      ota_page.remove_ble_dialog();
    }
  },

  ota_watchdog: function(timeout_in) //If time_in is 0, end watchdog -- file transfer complete?
  {
    var timeout = timeout_in;
    clearTimeout(file_transfer.timeout); //gets cleared every call

    if(timeout != 0)
    {
      ota_update.timeout = setTimeout(()=>{ //if this gets called, file transfer ends.
        console.log("Watchdog!!!");
      }, timeout);
    }
  },

  ota_reset: function()
  {
    ota_update.update_ui.reason = "";
    ota_update.attempts = 0;
    ota_update.time_keeper = 0;
  },

  ota_process_next: function(threshold, next, failure, this_function)
  {
    if(ota_update.attempts < threshold.attempts)
    {
      ota_update.response = this_function();

      if(ota_update.response) //next step
      {
        ota_update.update_ui.state = next; //next mode
        ota_update.ota_reset();
      }
      else if(!ota_update.response || (ota_update.time_keeper > threshold.timeout))
      {
        ota_update.attempts++;
        ota_update.time_keeper = 0;
      }
    }
    else
    {
      ota_update.update_ui.state = "failed";
      ota_update.update_ui.reason = failure;
    }
  },

  process_update_modes: function()
  {
    ota_update.process_interval = setInterval(function()
    {
      switch(ota_update.update_ui.state)
      {
        case "get_file":

          if((ota_update.time_keeper >= ota_update.file_threshold.timeout) || ota_update.attempts == 0) //otherwise stuff is out of sync... first time should be fast
          {
            ota_update.ota_process_next(ota_update.file_threshold, "get_connected", "Failed to get firmware", ota_update.get_firmware);
          }

        break;

        case "get_connected":

          if((ota_update.time_keeper >= ota_update.connection_threshold.timeout)) //otherwise stuff is out of sync... first time should be fast
          {
            ota_update.update_attempts++;

            if(ota_update.in_update)
            {
              ota_update.get_connected();
            }
          }

        break;

        case "connect_device":

          if((ota_update.time_keeper >= ota_update.connection_threshold.timeout))
          {
            ota_update.connect_ota();
            ota_update.update_attempts++;
            ota_update.time_keeper = 0;
          }

        break;

        case "get_dfu":

          if(ota_update.time_keeper >= ota_update.dfu_threshold.timeout)
          {
            ota_update.ota_process_next(ota_update.dfu_threshold, "ota_scan", "DFU mode failed", ota_update.get_dfu);
          }

        break;

        case "ota_scan":

          if((ota_update.time_keeper >= ota_update.ota_scan_threshold.timeout))
          {
            if(!ota_update.in_scan)
            {
              ota_update.ota_scan();
            }
            else
            {
              ota_update.attempts++;
            }

            if(ota_update.attempts == 16) //one more
            {
              ble.stopScan(function()
              {
                ota_update.ota_scan();
              });
            }
            else if(ota_update.attempts > 32)
            {
              ota_update.in_scan = false;
              ota_update.ota_reset();
              ota_update.update_ui.state = "failed";
              ota_update.update_ui.reason = "Couldn't find OTA";
            }
          }

        break;

        case "set_mtu":

          if(ota_update.time_keeper >= ota_update.ota_mtu_threshold.timeout)
          {
            ota_update.set_mtu();
            ota_update.ota_reset();
          }

        break;

        case "ota_write_byte":

          if(ota_update.time_keeper >= ota_update.ota_byte_threshold.timeout) //make it wait
          {
            ota_update.ota_process_next(ota_update.ota_byte_threshold, "transfer", "Failed to write OTA byte", ota_update.write_ota_byte);
          }

        break;

        case "transfer":

          if(ota_update.time_keeper >= ota_update.transfer_threshold.timeout) //make it wait
          {
            ota_update.ota_process_next(ota_update.transfer_threshold, "failed", "Update transfer failed", ota_update.transfer_data);
          }

        break;

        case "failed":

          console.log("Error: " + ota_update.update_ui.reason);
          ota_page.update_ui("Error: " + ota_update.update_ui.reason);
          ota_update.ota_reset();
          ota_update.next_attempt();

        break;

        case "update_fail":

          ota_update.kill_update();
          ons.notification.confirm({message: "Update failed: Too many attempts", cancelable: true, title: "Update Error", buttonLabels: ["Ok"], primaryButtonIndex: 0});

        break;

        case "end":
          console.log("Update ended");
        break;

      }

      ota_update.time_keeper += 250;

    }, 250);
  },

  next_attempt: function()
  {
    ota_update.update_attempts++;
    console.log("Update attempts: " + ota_update.update_attempts);

    if(ota_update.update_attempts > 3) //kill
    {
        ota_update.update_ui.state = "update_fail";
    }
    else
    {
      if(!ota_update.firmware)
      {
        ota_update.start_process_interval("get_file");
      }
      else
      {
        ota_update.start_process_interval("get_connected");
      }

      ota_page.update_ui("Restarting update process");
    }
  },

  write_ota_byte: function()
  {
    ota_update.update_ui.state = "transfer";

    ble_client.write_w_response(ota_update.device.id, ota_gatt.service, ota_gatt.control, "00")
    .then(function(result)
    {
      if(result)
      {
        console.log("Wrote OTA byte 00");
        ota_update.update_ui.state = "transfer";
        ota_update.ota_reset();
      }
      else
      {
        return false;
      }
    });
  },

  ota_scan: function()
  {
    ota_update.in_scan = true;

    ota_page.update_ui("Scanning for OTA");

    if(ota_update.in_update)
    {
      setTimeout(()=>{
      ble.startScan([], function(scan_device)
      {
        if(scan_device.name == "OTA" && ota_update.in_update)
        {
          ota_page.update_ui("OTA mode found");
          ota_update.device.name = "OTA"; //NEED THIS!
          console.log("We found device to update: " + scan_device.id);

          ble.stopScan(function()
          {
            console.log("Stopping OTA scan");
            ota_update.update_ui.state = "get_connected";
            ota_update.ota_reset();
          });
        }
      });
    }, 500);
    }
    else //safety
    {
      ble.stopScan();
      ota_update.update_ui.state = "end";
    }
  },

  get_dfu: function() // need to check if connected
  {
    ota_page.update_ui("Acquiring DFU mode: " + ota_update.attempts);

    ble_client.write_w_response(ota_update.device.id, ota_gatt.service, ota_gatt.control, "00")
    .then(function(result)
    {
      if(result)
      {
        ota_page.update_ui("DFU Acquired");
        ota_update.ota_reset();
        ble_client.disconnect(ota_update.device);
        ota_update.update_ui.state = "ota_scan";
      }
    });
  },

  get_connected: function() //go through the steps to OTA
  {
    ota_page.update_ui("Connecting: " + ota_update.device.id);

    ble.isConnected(ota_update.device.id, function()
    {
      if(ota_update.in_update)
      {
        ota_page.update_ui(" Connected");

        if(ota_update.device.name != "OTA") //we don't send DFU command if we already in DFU..
        {
          console.log("isConnected, writing control. " + ota_update.device.id);
          ota_update.update_ui.state = "get_dfu";
          ota_update.ota_reset();
        }
        else //just start transfer update
        {
          ota_page.update_ui(" Starting transfer");
          ota_update.update_ui.state = "ota_write_byte";
          ota_update.ota_reset();
        }
      }
      else
      {
        console.log("NOT IN UPDATE... CONNECTION CHECK");
      }
    },
    function()
    {
      ota_update.update_ui.state = "connect_device";
      ota_update.ota_reset();
    });
  },

  device_check: function()
  {
    if(ota_update.device.name != "OTA") //we don't send DFU command if we already in DFU.. Duh
    {
      console.log("Connected, writing control. " + ota_update.device.id);
      ota_update.update_ui.state = "get_dfu";
      ota_update.ota_reset();
    }
    else //start transfer
    {
      ota_page.update_ui(" Setting MTU");
      ota_update.update_ui.state = "set_mtu";
      ota_update.ota_reset();
    }
  },

  connect_ota: function()
  {
    if(ota_update.in_update)
    {
      ble.connect(ota_update.device.id, function()
      {
        ota_page.update_ui(" Connected: " + ota_page.device.id);
        ota_update.ota_reset();

        ble.refreshDeviceCache(ota_update.device.id, 1500, function()
        {
          console.log("Refreshed: " + ota_update.device.id);
          ota_page.update_ui(" Refreshing cache");
          ota_update.device_check();
        },
        function()
        {
          console.log("Refresh failed: " + ota_update.device.id);
          ota_page.update_ui(" Refresh failed");
          ota_update.device_check();
        });
      });
    }
  },

  write_firmware_packet: function(start_offset, end_offset, mtu)
  {
    var packet = "";
    var progress = 0;

    if((start_offset + mtu) >= ota_update.firmware.length)
    {
      packet = byteToHexString(ota_update.firmware.slice(start_offset));
    }
    else
    {
      packet = byteToHexString(ota_update.firmware.slice(start_offset, end_offset));
    }

    if(ota_update.kill == 1)
    {
      start_offset = ota_update.firmware.length;
    }

    if(start_offset < ota_update.firmware.length)
    {
      ble.write(ota_update.device.id, ota_gatt.service, ota_gatt.data, hexStringToByte(packet).buffer, function(w)
      {
        start_offset += mtu;
        progress = ((start_offset / ota_update.firmware.length) * 100).toFixed(2) + "%";

        console.log("Progress: " + progress + " Offset: " + end_offset + "\n Packet: " + packet + " \n");

        if(start_offset > ota_update.firmware.length)
        {
          ota_page.update_progress("100%");
        }
        else
        {
          ota_page.update_progress(progress);
        }

        end_offset += mtu;
        ota_update.write_firmware_packet(start_offset, end_offset, mtu); //yes this is recursive
      },
      function(e)
      {
        ons.notification.confirm({message: "Error: " + JSON.stringify(e), cancelable: true, title: "Update Error", buttonLabels: ["Ok"], primaryButtonIndex: 0})
          .then(()=>{
            ota_update.end_update();
          });

        console.log("ID: " + ota_update.device.id + " Offset: " + end_offset + "Packet: " + packet + " \nError: "+ JSON.stringify(e));
      });
    }
    else //either way
    {
      if(ota_update.kill == 0)
      {
        packet = "03";

        ble.write(ota_update.device.id, ota_gatt.service, ota_gatt.control, hexStringToByte(packet).buffer, function(w)
        {
          ota_page.update_ui("Update complete");
          ble_client.write_w_response(ota_update.device.id, ota_gatt.service, ota_gatt.control, "04");
          ota_update.in_update = false;
        },
        function(e)
        {
          ota_page.update_ui("Error with: " + JSON.stringify(e));
          ble_client.write_w_response(ota_update.device.id, ota_gatt.service, ota_gatt.control, "04");
          ota_update.in_update = false;

        });
      }
      else
      {
          console.log("User killed update...");
          ota_update.in_update = false;
      }
    }
  },

  set_mtu: function() //this starts update transfer to ble module
  {
    ble.requestMtu(ota_update.device.id, 247, function()
    {
      console.log("Successfully set mtu to 247");
      ota_update.mtu = 244;
      ota_page.update_ui("MTU: " + ota_update.mtu);
      ota_update.update_ui.state = "ota_write_byte";
      ota_update.ota_reset();
    },
    function(e)
    {
      console.log("Failed to set MTU: " + JSON.stringify(e));
      ota_page.update_ui("MTU: " + ota_update.mtu);
      ota_update.update_ui.state = "ota_write_byte";
      ota_update.ota_reset();
    });
  },

  transfer_data: function()
  {
    ota_update.stop_process_interval();
    ota_page.update_ui("Uploading firmware");
    ota_update.write_firmware_packet(0, ota_update.mtu, ota_update.mtu);
  },

  kill_update: function()
  {
    ota_update.kill = 1;
    ota_update.end_update();
  }
}
