var canbus = {

  last: "",
  first:  "",

  parse_canbus: function(raw_in, device)
  {
    //console.log("Raw: " + raw_in + "\n");
    var context_out = device.context;
    var process_can = raw_in;
    var frame = "";
    var frame_out = "";
    var byte = "";
    var length = 0;
    var i = 0;

    byte = process_can.substring(0, 2);

    if(byte != "1B")
    {
      canbus.first_frame_check(process_can, context_out);
    }

    while(i < process_can.length)
    {
      byte = process_can.substring(i, (i + 2));

      if(byte == "1B")
      {
          if(i + 12 <= process_can.length) //get DLC
          {
            length = parseInt(process_can.substring(i + 10, i + 12), 16); //get length of data_in

            if((i + 12 + (length * 2) <= process_can.length) && (length <= 8)) //check data length and frame length
            {
              frame = process_can.substring(i, (i + 12) + (length * 2));
              i += frame.length;
              frame_out = canbus.deconstruct_frame(frame);
              context_out.receive_stream.call(context_out, frame_out); //send frame back to device
            }
            else
            {
              canbus.last = process_can.substring(i);
              break;
            }
          }
          else
          {
            canbus.last = process_can.substring(i);
            break;
          }
      }
      else
      {
        i+=2;
      }
    }
  },

  end_frame_check: function(end_pos, can_in)
  {
    var can_out = can_in;
    var tmp = can_out.substring(end_pos, (end_pos+2));
    canbus.last = "";

    if(tmp == "1B")
    {
      for(var j = end_pos + 2; j <= can_out.length; j+=2)
      {
        canbus.last += tmp;
        tmp = can_out.substring(j, (j+2));
      }

      console.log("END: " + can_out);
    }
  },

  first_frame_check: function(can_in, con) // remove first non complete header info
  {
    var context = con;
    var can_out = can_in;
    var tmp = can_out.substring(0, 2); //first byte char
    canbus.first = "";

    if(tmp != "1B")
    {
      for(var j = 2; tmp != "1B";  j+=2)
      {
        canbus.first += tmp;
        tmp = can_out.substring(j, (j + 2));
      }
    }

    if(canbus.first != "" && canbus.last != "") // combine partial tails and heads
    {
      var combined = canbus.last + canbus.first;

      if(combined.length > 28 || combined.length < 12) //double length because we are using chars not HEX values
      {
        console.log("CONSTRUCTED FRAME ERROR: " + combined);
      }
      else
      {
        //console.log("CONSTRUCTED PARTIAL PACKET: " + canbus.last + canbus.first);
        var out = canbus.deconstruct_frame(combined);
        context.receive_stream.call(context, out);
      }

      canbus.first = "";
      canbus.last = "";
    }
  },

  construct_frame: function(can_obj_in)
  {
    var can_obj = can_obj_in;

    var can_frame = "";
    var can_bytes = 0x00000000;

    can_bytes = can_bytes | (parseInt(can_obj.serial_bits, 2) << 29);

    can_bytes = can_bytes | (parseInt(can_obj.register, 16) << 18);

    can_bytes = can_bytes | (parseInt(can_obj.device_type, 16) << 11);

    can_bytes = can_bytes | (parseInt(can_obj.index, 16) << 7);

    can_bytes = can_bytes | pad(parseInt(can_obj.bus_id, 16), 2);

    can_frame = "1B" + can_bytes.toString(16);
    can_frame += pad(can_obj.dlc, 2);
    can_frame = (can_frame + can_obj.data).toUpperCase();

    return can_frame;
  },

  three_bits: function(byte)
  {
    return pad((byte >> 5).toString(2), 3);
  },

  deconstruct_frame: function(frame)
  {
    var top_three = canbus.three_bits(parseInt(frame.substring(2,4), 16)); //rtr bit 0010 0000
    var register = pad(((parseInt(frame.substring(2, 6), 16) & 0x1FFC) >> 2).toString(16), 3);  //strip off leading 0 and extended bit... get address 0001 1111 1111 1100 ;
    var device_type = pad(((parseInt(frame.substring(5, 8), 16) & 0x3F8) >> 3).toString(16), 2); //device type 0011 1111 1000
    var index = ((parseInt(frame.substring(7, 9), 16) & 0x78) >> 3).toString(16); //index 0111 1000
    var busid = pad((parseInt(frame.substring(8, 10), 16) & 0x7F).toString(16), 2); //bus id 0111 1111
    var dlc = (parseInt(frame.substring(10, 12), 16) & 0x7F).toString(16); //bus id 0111 1111
    var data = frame.substring(12);

    var frame = {type: "frame", serial_bits: top_three, register: register.toUpperCase(), device_type: device_type.toUpperCase(), index: index, bus_id: busid.toUpperCase(), dlc: dlc, data: data, raw: frame};

    return frame;
  },

  convert_out: function(message_in)
  {
    var out = message_in;
    out.data_out = {desc: canbus_map[out.register].desc, values: canbus.get_values(out.register, out.data)};
    return out;
  },

  get_values: function(register, data)
  {
    var value = [];
    var reg_map = canbus_map[register];
    let data_offset = 0;

    for(var i = 0; i < reg_map.register_type.length; i++)
    {
      if(reg_map.hasOwnProperty("register_multiplier") && (typeof reg_map.register_multiplier[i] !== "string")) //simple value extraction
      {
        if(reg_map.hasOwnProperty("granularity"))
        {
          if(typeof reg_map.granularity[i] !== "string") //does not have string as granularity
          {
            value.push({type: reg_map.register_units[i], value: (parseInt(data.substring(data_offset, (data_offset + reg_map.register_type[i] * 2)), 16) * reg_map.register_multiplier[i] * reg_map.granularity[i])}); //granularity
          }
          else
          {
            value.push({type: reg_map.register_units[i], value: (parseInt(data.substring(data_offset, (data_offset + reg_map.register_type[i] * 2)), 16) * reg_map.register_multiplier[i])}); //no granularity
          }
        }
      }
      else if(reg_map.hasOwnProperty("register_multiplier") && (typeof reg_map.register_multiplier[i] == "string")) //should get enum key from message
      {
        value.push({type: reg_map.register_units[i], value: canbus_map[reg_map.register_multiplier[i]][parseInt(data.substring(data_offset, (data_offset + reg_map.register_type[i] * 2)), 16).toString()]});
      }
      else //no register_multiplier
      {
        value.push({type: reg_map.register_units[i], value: data.substring(data_offset, (data_offset + reg_map.register_type[i] * 2))});
      }

      data_offset += reg_map.register_type[i] * 2;
    }
    return value;
  },

  poll_register: function(register, bus_id_in) //packed
  {
    var poll_request = canbus.construct_frame({serial_bits: "011", register: register, device_type: "70", index: "0", bus_id: bus_id_in, dlc: 0, data: ""});
    return poll_request;
  },

  get_meta: function(register, meta_type, bus_id_in) //contruct meta request and send it out
  {
    console.log("meta_type: " + meta_type + " : bus_id : " + bus_id_in);
    var meta_request = canbus.construct_frame({serial_bits: "011", register: register, device_type: meta_type, index: "0", bus_id: bus_id_in, dlc: 0, data: ""});
    return meta_request;
  }
};

const canbus_map =
{
  device_types: {"30": "Rosie", "2B": "Hawke's Bay", "1B": "Hawke's Bay Old", "2C": "Barcelona", "14": "MNGP2", "0B": "Combox", "2E": "Classic", "2A": "B17mppt", "3C": "B17inv"},
  variant: {"2B": {"00": "RESERVED", "01": "90", "02": "120"}, "14": {"00": "RESERVED", "01": "std"}, "2C": {"00": "RESERVED", "01": "200"}, "30": {"00": "RESERVED", "01": "re", "02": "rv"},
    "2A": {"00": "RESERVED", "01": "TBD"}, "3C": {"00": "RESERVED", "01": "TBD"}},
  charge_stages: {"0": "Resting", "1": "Bulk MPPT", "2": "Absorb", "3": "Float", "4": "Equalize", "5": "Float MPPT", "6": "EQ MPPT"}, //charge stage enum
  inverter_status: {"1": "Off", "2": "Sleeping", "3": "Starting", "4": "Mppt", "5": "Throttled", "6": "Shutting Down", "7": "Fault", "8": "Standby"},
  inverter_error: {"1": "Ground fault", "2": "Over voltage", "3": "Disconnect open", "4": "Disconnect open", "5": "Grid disconnect", "6": "Cabinet open", "7": "Manual shutdown",
    "8": "Over temperature", "9": "Frequency above limit", "10": "Frequency under limit", "11": "Voltage above limit", "12": "Voltage under limit", "13": "Blown String fuse on input",
    "14": "Under temperature", "15": "Communication error", "16": "Hardware test failure"},

  //GLOBAL REGISTER  STATUS BLOCK
  "004": {desc: "System Heartbeat", register_type: [4], register_units: ["Heartbeat"]},
  "008": {desc: "Global Control Set", register_type: [8], register_units: ["Global Control"]},
  "009": {desc: "Global Control Clear", register_type: [8], register_units: ["Global Clear"]},
  "00E": {desc: "Global Control Read", register_type: [4], register_units: ["Control Bit Field"]},

  //DC OUTPUT BLOCK
  "020": {desc: "DC Instantaneous1 Out", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "021": {desc: "Output DC Average", register_type: [2,2,4], register_units: ["V","A","W"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "024": {desc: "DC Instantaneous2 Out", register_type: [4], register_units: ["Status"]},

  //DC INPUT STATUS BLOCK
  "080": {desc: "DC Instantaneous1", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "081": {desc: "Input DC Average", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 100], granularity: [.01, .1, .0001]},
  "084": {desc: "DC Instantaneous2", register_type: [4], register_units: ["Status"]},

  //BATTERY STATUS BLOCK
  "0A0": {desc: "Battery", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .0001]},
  "0A1": {desc: "DC AUX Discharge", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 1000], granularity: [.01, .01, .01]},
  "0A2": {desc: "DC Peak VI", register_type: [2 ,2 ,2, 2], register_units: ["Vmax", "Vmin", "Imax", "Imin"], register_multiplier: [10, 10, 10, 10], granularity: [.01, .01, .01, .01]},
  "0A3": {desc: "Battery Status", register_type: [1, 1, 2, 2], register_units: ["Charge_stage", "Temp_status", "Time_in_stage", "Temperature"], register_multiplier: ["charge_stages" ,1 ,1 ,10], granularity: ["","","", .01]},
  "0A6": {desc: "Battery Health", register_type: [2, 1, 1], register_units: ["Cycle_count", "DOD", "SOC"], register_multiplier: [1,1,1], granularity: ["","",""]},
  "0A7": {desc: "Battery DC Charge", register_type: [4, 4], register_units: ["AH", "WH"], register_multiplier: [100, 100], granularity: [.01, .01]},
  "0A8": {desc: "DC Discharge", register_type: [4, 4], register_units: ["AH", "WH"], register_multiplier: [100, 100], granularity: [.01, .01]},
  "0A9": {desc: "Bat DC Peak", register_type: [4, 4], register_units: ["Pmax", "Pmin"], register_multiplier: [100, 100], granularity: [.01, .01]},

  //AC OUTPUT BLOCK
  "040": {desc: "Phase A vcf", register_type: [2, 2, 2], register_units: ["V", "A", "Hz"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "041": {desc: "Phase A p1", register_type: [4, 4], register_units: ["W", "VA"], register_multiplier: [100, 100], granularity: [.01, .01]},
  "042": {desc: "Phase A p2", register_type: [4, 2], register_units: ["VAr", "PF"], register_multiplier: [100, 100], granularity: [.01, .01]},
  "043": {desc: "Phase B vcf", register_type: [2, 2, 2], register_units: ["V", "A", "Hz"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "044": {desc: "Phase A p1", register_type: [4, 4], register_units: ["W", "VA"], register_multiplier: [100, 100], granularity: [.01, .01]},
  "04A": {desc: "AC Wh1", register_type: [4, 4], register_units: ["Wh", "Wh"], register_multipler: [100, 100], granularity: [.01, .01]},

  //INVERTER SPECIFIC VALUES
  "0C0": {desc: "Inverter Status", register_type: [1, 4], register_units: ["Status", "Error Bits"], register_multiplier: ["inverter_status", "inverter_error"]},

  //Auxilliary modes
  //"0E0": {desc: "Aux Status", [1,1,1,1,1,1,1,1], register_units: ["aux1,aux2,aux3,aux4,aux5,aux6,aux7,aux8"], register_multiplier: []},

  //DEVICE DEBUG STATUS BLOCK
  "261": {desc: "Temperature 1", register_type: [2, 2, 2, 2], register_units: ["t1", "t2", "t3", "t4"], register_multiplier: [10, 10, 10, 10], granularity: [.01, .01, .01, .01]},
  "262": {desc: "Temperature 2", register_type: [2, 2, 2, 2], register_units: ["t1","t2", "t3", "t4"], register_multiplier: [10, 10, 10, 10], granularity: [.01, .01, .01, 01]},
  "263": {desc: "Fast monitor1", register_type: [8], register_units: "Engineer"},
  "264": {desc: "Fast monitor2", register_type: [8], register_units: "Engineer"},
  "265": {desc: "Fast monitor2", register_type: [8], register_units: "Engineer"},
  "266": {desc: "Fast monitor2", register_type: [8], register_units: "Engineer"},

  //AGGREGATE BATTERY STATUS BLOCK
  "300": {desc: "Battery Charge/Discharge", register_type: [2, 2, 4], register_units: ["V", "A", "W"], register_multiplier: [10, 10, 100], granularity: [.01, .01, .01]},
  "301": {desc: "Battery AG", register_type: [4, 4], register_units: ["AH", "NA"]},
  "302": {desc: "Battery In", register_type: [4, 4], register_units: ["AH", "WH"], register_multiplier: [100, 100]},

  //DISCHARGE STATUS BLOCK
  "3F0": {desc: "Discovery/UUID", register_type: [1, 1, 4], register_units: ["rev", "sub_count", "uuid"]},
  "3F1": {desc: "Implemented Registers", register_type: [8], register_units: "Implemented Registers"},
  "3F2": {desc: "Global Status", register_type: [1, 4], register_units: ["Enum", "Error Bit Field"]},
  "3F3": {desc: "Serial1", register_type: [8], register_units: ["Serial1"]},
  "3F4": {desc: "Serial2", register_type: [8], register_units: ["Serial2"]},
  "3F5": {desc: "Producet ID1", register_type: [8], register_units: ["Product_ID1"]},
  "3F6": {desc: "Producet ID1", register_type: [8], register_units: ["Product_ID2"]},
  "3F7": {desc: "Device name1", register_type: [8], register_units: ["Device name1"]},
  "3F8": {desc: "Device name2", register_type: [8], register_units: ["Device name2"]},
  "3F9": {desc: "Firmware Revision", register_type: [8], register_units: ["Firmware Version"]},
};
