var file_management = {

  firmware_map_filename: "release_map.json",
  firmware_path: "http://www.midnitesolar.info/release/",
  map_file: "undefined",
  dir_location: "firmware",
  dir_entry: "undefined",
  file_entry: "undefined",

  get_file: function(location, file_name)
  {
    var uri = "location";
    var file = file_name;

    if(uri == "" && file == "" && dialog != undefined) //update with popup for firmware selection
    {
      file_management.select_file("ota_update", dialog); //dialog; {type:"select", title:"Pick firmware", loc: "ota_update", value: "", changed:false, list:["MNGP2", "MNGP20", "MNBC"]}
    }
    else
    {
      file_management.download_file(uri, file, "arraybuffer");
    }
  },

  load_firmware_map: function() //check for internal map... download if it does not exist, return result
  {
    return new Promise((resolve)=>{

      file_management.download_map_file()
        .then((result)=>{
          if(result)
          {
            resolve(result);
          }
          else
          {
            console.log("SEARCHING FOR MAP FILE");
            file_management.find_local_file(file_management.firmware_map_filename)
              .then((find_local)=>{

                if(find_local != false) //we have a file...
                {
                  console.log("FOUND MAP FILE");
                  file_management.read_local_file(file_management.firmware_map_filename, "text")
                    .then((file_obj)=>{
                      if(file_obj)
                      {
                        file_management.map_file = file_management.convert_map_file(JSON.parse(file_obj.data.target._result));
                        //console.log("MAP: " + JSON.stringify(file_management.map_file));
                        resolve(file_management.map_file);
                      }
                    });
                }
                else
                {
                  resolve(false);
                }
            });
          }
        });
      });
  },

  convert_map_file: function(filename_array) //convert for compatibility with firmware update file read format
  {
    var file_names_obj = [];

    for(let i = 0; i < filename_array.length; i++)
    {
      file_names_obj.push({name: filename_array[i]});
    }

    return file_names_obj;
  },

  download_map_file: function()
  {
    return new Promise((resolve)=>{

      file_management.download_file(file_management.firmware_path + file_management.firmware_map_filename, file_management.firmware_map_filename, "text")
        .then((result)=>{
          if(result)
          {
            file_management.read_local_file(file_management.firmware_map_filename, "text")
              .then((file_obj)=>{
                if(file_obj)
                {
                  file_management.map_file = file_management.convert_map_file(JSON.parse(file_obj.data.target._result));//JSON.parse(file_obj.data.target._result.toString());
                  //file_management.map_file.modified = file_obj.mod_date;
                  //console.log("MAP: " + JSON.stringify(file_management.map_file));
                  resolve(file_management.map_file);
                }
                else
                {
                  resolve(false);
                }
            });
          }
          else
          {
            resolve(false);
          }
      });
    });
  },

  convert_to_millis: function(time_string)
  {
    let time_arr = time_string.split(/[-\s:]/);
    time_arr[1] = (parseInt(time_arr[1]) - 1); //0 - 11 month
    let date = new Date(time_arr[0], time_arr[1], time_arr[2], time_arr[3], time_arr[4], time_arr[5]);
    return date.getTime();
  },

  remote_map_mod_date: function()
  {
    return new Promise((resolve)=>{
        ftp_client.get_list("/")
          .then((list)=>{
            let i = 0;
            for(; list[i].name != file_management.firmware_map_filename && i < list.length; i++);

            if(list[i].name == file_management.firmware_map_filename)
            {
              resolve(file_management.convert_to_millis(list[i].modifiedDate));
            }
            else
            {
              resolve(false);
            }
      });
    });
  },

  find_local_file: function(name_in)
  {
    let name = name_in;
    var found = "";

    return new Promise((resolve)=>{

      file_management.get_local_dir_listing()
        .then((entries)=>{

            for(let i = 0; i < entries.length; i++)
            {
              if(entries[i].name == name && entries[i].isFile)
              {
                found = entries[i];
                break;
              }
            }
          }).then(()=>{

            if(found != "")
            {
              resolve(found);
            }
            else
            {
              resolve(false);
            }
          });
      });
  },

  read_local_file: function(file_in, type_in)
  {
    let file_name = file_in;
    let type = type_in;

    return new Promise((resolve)=>{
      file_management.get_directory_entry()
        .then(()=>
        {
          file_management.dir_entry.getFile(file_name, {create: true}, (file_entry)=>
          {
            file_entry.file((file)=>{
              var reader = new FileReader();

              reader.onloadend = function(read) {
                //console.log("FINISHED READING FILE: " + JSON.stringify(read));
                resolve({data:read, mod_date: file.lastModified});
              };

              if(file)
              {
                //console.log("READ FILE: " + JSON.stringify(file));

                switch(type_in)
                {
                  case "text":
                    reader.readAsText(file);
                    break;

                  case "dataURL":
                    reader.readAsDataURL(file);
                  break;

                  case "arraybuffer":
                    reader.readAsArrayBuffer(file);
                  break;
                }
              }
              else
              {
                console.log("INVALID FILE OBJECT");
                resolve(false);
              }

            },(e)=>{
              console.log("Error reading File: " + JSON.stringify(e));
              resolve(false);});
          });
        });
      });
  },

  get_directory_entry: function()
  {
    return new Promise((resolve)=>{

      file_management.dir_entry = "undefined"; //saftey

      window.resolveLocalFileSystemURL(cordova.file.externalApplicationStorageDirectory, (directory_entry)=>
      {
        file_management.dir_entry = directory_entry;
        resolve();
      },
      function(error)
      {
        console.log("Failed to get directory entry: " + JSON.stringify(error));
        resolve();
      });
    });
  },

  download_file: function(uri_in, file, type_in)
  {
    var file_name = file;
    var uri = uri_in;
    var type = type_in;

    return new Promise((resolve, reject) =>
    {
      console.log("File Location: " + uri);

      var fileTransfer = new XMLHttpRequest();
      var file_array = "undefined";

      fileTransfer.open("GET", uri, true);
      fileTransfer.responseType = type;

      fileTransfer.onloadend = function(event)
      {
        var entry = fileTransfer.response;

        if(entry)
        {
          console.log("Download Complete: TYPE: " + type + " : URI: " + uri + " : " + entry);

          switch(type)
          {
            case "arraybuffer":
             file_array = new Uint8Array(entry);
            break;

            case "text":
             file_array = entry;
            break;
          }

          //file_management.get_directory_entry();
          console.log("Filename: " + file_array.length + " : " + file_name);

          if(file_array.length > 0)
          {
            file_management.save_to_local_storage(file_array, file)
              .then(()=>{
                resolve(file_array);
              });
          }
        }
        else
        {
          resolve(false);
          console.log("Error on download response: " + JSON.stringify(event));
        }
      }
      fileTransfer.send();
    });
  },

  save_to_local_storage: function(data, name)
  {
    let file_data = data;
    let file_name = name;

    return new Promise((resolve)=>{

    file_management.get_directory_entry()
      .then(()=>{

        console.log("Attempting to write download to local storage");

        file_management.dir_entry.getFile(file_name, { create: true, exclusive: false }, (file)=>
        {
          file_management.file_entry = file;

          file_management.file_entry.createWriter((file_writer)=>
            {
              file_writer.onwriteend = function()
              {
                console.log("Successful file write: " + file_name);
                resolve(true);
              };

              file_writer.write(file_data);
            });
        },
        function(error)
        {
          console.log("File creation error:" + JSON.stringify(error));
          resolve(error);
        });
      });
    });
  },

  get_local_dir_listing: function()
  {
    return new Promise((resolve)=>{
      file_management.get_directory_entry()
        .then(()=>
        {
          var d_reader = file_management.dir_entry.createReader();

          d_reader.readEntries((entries)=>
          {
            resolve(entries);
          },
          function(err)
          {
            console.log("Directory read error: " + JSON.stringify(err));
            resolve(false);
          });
        });
      });
  },

  get_local_dir_file_listing: function() //same as directory listing without non file info
  {
    return new Promise((resolve)=>{
      file_management.get_local_dir_listing()
        .then((entries)=>{
          var files_list = [];

          for(let i = 0; i < entries.length; i++)
          {
            if(entries[i].isFile)
            {
              files_list.push(entries[i]);
            }
          }

          if(files_list.length > 0)
          {
            resolve(files_list);
          }
          else
          {
            resolve(false);
          }
        });
      });
  },

  delete_local: function(file)
  {
    let filename = file.name;

    return new Promise((resolve)=>{
      file_management.get_directory_entry()
        .then(()=>
        {
          file_management.dir_entry.getFile(filename, {create: false}, (file_entry)=>
          {
            file_entry.remove(()=>{
              console.log("FILE REMOVED: " + filename);
              resolve(true);
            }, (err)=>{
              console.log("ERROR REMOVING FILE: " + err);
              resolve(false);
            });
          });
        });
      });
  },

  select_file: function(id, dialog_content)
  {
    var title = diag_title;
    var dialog_string = dialog_content;
    settings_dialog.open_dialog(id, dialog_string); //good idea,thanks
  }
}
