var firmware_downloader ={
  firmwares_remote_list: "undefined",
  firmwares_local_list: [], //local

  /****************** Model ********************/
  files_to_download: ["hbay_120", "blna_200", "rosie_re", "rosie_rv", "mngp2_std"],
  /*********************************************/

  in_check: false,

  init: function(dialog) //main
  {
    firmware_downloader.in_check = false;
    firmware_downloader.firmwares_local_list = "undefined";

    dialog.show()
      .then(()=>{
        firmware_downloader.add_events();
        firmware_downloader.firmware_checks();
      });
  },

  firmware_checks: function()
  {
    firmware_downloader.get_local_firmwares_list()
      .then((file_list)=>{
        firmware_downloader.show_file_list(file_list);
      });
  },

  /****************** VIEW *********************/

  show_file_list: function(file_list_in)
  {
    var file_list = file_list_in;

    return new Promise((resolve)=>{

      let list = $("#dler_list");

      if($("#dler_list").length == 1)
      {
        ons_createAttach("<ons-list-item id='none_file'><div class='center'>NONE</div></ons-list-item>", list);
      }

      for(let i = 0; i < file_list.length; i++)
      {
        if(firmware_downloader.check_name(file_list[i].name))
        {
          if($("#" + firmware_downloader.id_device_name(file_list[i].name)).length == 0)
          {
            firmware_downloader.check_none();
            ons_createAttach("<ons-list-item id='" + firmware_downloader.id_device_name(file_list[i].name) + "'><div class='center'>" + file_list[i].name + "</div></ons-list-item>", list);
          }
          else
          {
            $("#" + firmware_downloader.id_device_name(file_list[i].name)).remove();
            ons_createAttach("<ons-list-item id='" + firmware_downloader.id_device_name(file_list[i].name) + "'><div class='center'>" + file_list[i].name + "</div></ons-list-item>", list);
          }
        }
      }
        resolve(file_list);
    });
  },

  check_name: function(file_name)
  {
    let i = 0;

    for(; i < firmware_downloader.files_to_download.length; i++)
    {
      if(file_name.search(firmware_downloader.files_to_download[i]) != -1)
      {
        return true;
      }
    }

    if(i >= firmware_downloader.files_to_download.length)
    {
      return false;
    }
  },

  update_firmware_status: function(status)
  {
    if(status != "")
    {
      $("#dler_header").html("LOCAL FIRMWARES");
    }
    else
    {
      $("#dler_header").html("LOCAL FIRMWARES");
    }
  },

  id_device_name: function(name)
  {
    var name_out = name.split("_");
    name_out = name_out[0] + name_out[1] + name_out[2];
    return name_out;
  },

  update_firmware_list: function(device_listing)
  {
    firmware_downloader.check_none();

    if($("#" + firmware_downloader.id_device_name(device_listing.name)).length > 0)
    {
      $("#" + firmware_downloader.id_device_name(device_listing.name)).html("<div class='center list-item__center' style='color:green;'>" + device_listing.name + "</div>");
    }
    else
    {
      ons_createAttach("<ons-list-item id='" + firmware_downloader.id_device_name(device_listing.name) + "'><div class='center' style='color:green;'>" + device_listing.name + "</div></ons-list-item>", $("#dler_list"));
    }
  },

  check_none: function()
  {
    console.log("REMOVING NONE FILE");

    if($("#none_file").length > 0) //None UI
    {
      $("#none_file").remove();
    }
  },

  /*********************************************/

  /**************** Control ********************/

  get_local_firmwares_list: function()
  {
    return new Promise((resolve)=>{
      file_management.get_local_dir_file_listing()
        .then((file_list)=>{

          firmware_downloader.firmwares_local_list = file_list;
          console.log("FIRMWARE LIST: " + JSON.stringify(firmware_downloader.firmwares_local_list));
          resolve(file_list);
        });
    });
  },

  check_remote: function()
  {
    return new Promise((resolve)=>{
      file_management.load_firmware_map()
        .then((remote_list)=>{

          if(remote_list != false && checkConnection().state != false)
          {
            firmware_downloader.remote_firmwares_list = remote_list;
            resolve(true);
          }
          else
          {
            resolve(false);
          }
        });
    });
  },

  get_check_firmwares: function()
  {
    return new Promise((resolve)=>{

      firmware_downloader.check_remote()
        .then((result)=>{

          if(!result)
          {
            ons.notification.alert("Firmware check unavailable. Check network connection to update local firmwares.");
            resolve(false);
          }
          else
          {
            let i = 0;
            let j = 0;
            let keys = "";
            var file_processed = 0;

            keys = Object.keys(firmware_downloader.remote_firmwares_list);

            console.log("REMOTE FIRMWARE LENGTH: " + keys.length);

            for(; i < keys.length; i++)
            {
              if(j >= firmware_downloader.files_to_download.length)
              {
                file_processed++;

                if(file_processed >= keys.length)
                  resolve(true);
              }

              for(j = 0; j < firmware_downloader.files_to_download.length; j++)
              {
                let remote_match = firmware_downloader.remote_firmwares_list[keys[i]].name.substring(0, firmware_downloader.files_to_download[j].length);

                if(remote_match == firmware_downloader.files_to_download[j]) //we have a match
                {
                  let result = firmware_downloader.check_against_local(firmware_downloader.remote_firmwares_list[keys[i]]);
                  console.log("REMOTE_MATCH: " + remote_match + " : LOCAL CHECK: " + result);

                  if(result == "newer" || result == "none") //download firmware
                  {
                    firmware_downloader.download_firmware(firmware_downloader.remote_firmwares_list[keys[i]])
                      .then(()=>{
                        file_processed++;

                        if(file_processed >= keys.length)
                          resolve(true);
                      });
                  }
                  else if(result == "same" || result == "exempt")
                  {
                    file_processed++;

                    if(file_processed >= keys.length)
                      resolve(true);
                  }
                  break;
                }
              }
              console.log("KEY" + i + " : " + JSON.stringify(firmware_downloader.remote_firmwares_list[keys[i]]) + "PROCESSED: " + file_processed);
            }
          }
        });
      });
  },

  download_firmware: function(remote_listing)
  {
    console.log("Downloading: " + JSON.stringify(remote_listing));
    var name = remote_listing.name;

    return new Promise((resolve)=>{
      file_management.download_file(firmware_update.base_path + remote_listing.name, remote_listing.name, "arraybuffer") //download and save to local
        .then((result)=>
        {
          if(result != false)
          {
            let j = 0;

            for(let i = 0; i<name.length; i++)
            {
              if(name[i] == "_")
              {
                j++;

                if(j == 3)
                {
                  name = name.substring(0,i);
                  break;
                }
              }
            }

            firmware_update.delete_oldest(name)
              .then(()=>{
                firmware_downloader.update_firmware_list(remote_listing);
                 resolve();
              });
          }
          else
          {
            resolve();
          }
        });
    });
  },

  check_against_local: function(remote_match)
  {
    let remote = remote_match.name.split("_");
    let remote_version = parseInt(remote[3]);

    remote = remote[0] + remote[1] + remote[2];

    if(firmware_downloader.firmwares_local_list == false || firmware_downloader.firmwares_local_list == "undefined")
    {
      return "none";
    }
    else
    {
      let keys = Object.keys(firmware_downloader.firmwares_local_list);
      let i = 0;

      for(; i < keys.length; i++)
      {
        let local = firmware_downloader.firmwares_local_list[keys[i]].name.split("_");

        if(local[2] != undefined) //need at least 3 tokens "device_variant_rev_"
        {
          let local_version = parseInt(local[3]);
          local = local[0] + local[1] + local[2];

          if(remote == local && remote_version == local_version)
          {
            console.log("REMOTE " + remote + " : " + remote_version + " is the same as " + local + " : " + local_version);
            return "same";
          }
          else if(remote == local && remote_version > local_version) //check version info
          {
            console.log("REMOTE " + remote + " : " + remote_version + " is newer than " + local + " : " + local_version);
            return "newer";
          }
        }
      }

      if(i >= keys.length)
      {
        return "none";
      }
    }
  },

  add_events: function()
  {
    $("#closer_dler").on("click", function()
    {
        $("#fw_dl_dialog").remove();
    });

    $("#refresh_dler").on("click", function()
    {
        if(firmware_downloader.in_check == false)
        {
          $("#refresh_dler ons-icon").attr("spin","");
          firmware_downloader.in_check = true;
        }

        if(firmware_downloader.in_check)
        {
          firmware_downloader.get_check_firmwares()
            .then(()=>{
              $("#refresh_dler ons-icon").removeAttr("spin");
              firmware_downloader.in_check = false;
          });
        }
    });

    $("#fw_dl_dialog").on("posthide", function()
    {
      $("#dler_list").empty();
    });
  }
  /*********************************************/
}
