function graph(id)
{
  var self = this;

  this.anchor = id;
  this.chart = "undefined"; //graph obj
  this.datasets = "undefined";
  this.config = "undefined";
  this.canvas = "undefined"; //id of canvas
  this.all_data = [];

  this.set_canvas = function(canvas_in)
  {
    this.canvas = canvas_in;
    $("#" + this.anchor).append("<canvas id='" + this.canvas.id + "' width='" + this.canvas.width + "' height='" + this.canvas.height + "'></canvas>");
  }

  this.set_config = function(config_in)
  {
    this.config = config_in;
  }

  this.set_data = function(data_in)
  {
    this.config.data = data_in;
    //console.log("GRAPH SET: " + JSON.stringify(this.config.data));
  }

  this.set_graph = function()
  {
    this.chart = new Chart($("#" + this.canvas.id), this.config);
  }

  this.reset = function()
  {
    this.config.data.labels = [];
    this.all_data = [];

    for(let i = 0; i < this.config.data.datasets.length; i++)
    {
      this.config.data.datasets[i].data = [];
    }
  }

  this.update_data = function(data_in, threshold)
  {
    let chart_data = data_in;

    if(chart_data.hasOwnProperty("log"))
    {
      if(chart_data.log == 1) //first set
      {
        this.reset()
      }
    }

    if(chart_data.hasOwnProperty("labels"))
    {
      this.config.data.labels = chart_data.labels.concat(this.config.data.labels);
    }

    for(let i = 0; i < chart_data.datasets.length; i++)
    {
      if(this.all_data[i] == undefined)
      {
        this.all_data[i] = chart_data.datasets[i].data;
      }
      else
      {
        this.all_data[i] = chart_data.datasets[i].data.concat(this.all_data[i]);
      }

      console.log("ALL DATA: " + JSON.stringify(this.all_data));

      if(threshold != "")
      {
        this.config.data.datasets[i].data = lttb(this.all_data[i], threshold, 'x', 'y');
      }
      else
      {
        this.config.data.datasets[i].data = this.all_data[i];
      }
    }

    console.log("UPDATE DATA: " + JSON.stringify(this.config.data));
    this.update();
  }

  this.show = function()
  {
    this.chart.show();
  }

  this.update = function()
  {
    this.chart.update();
  }
};

  /*this.set_layout_kWh = function()
  {
    this.layout = {
      title: 'kWh Per Day',
      barmode: 'stack', //stack the bar graphs
      color: '#2a2a2a',
      paper_bgcolor:"#2a2a2a",
      plot_bgcolor: "#2a2a2a",
      showlegend: true,
      fixedrange:true,
      showline: true,
      line:{color: '#FFFFFF'},

      font: { family: 'HelveticaNeue-Light, HelveticaNeue, Helvetica, Arial, sans-serif',
            size: 14,
            color: '#FFFFFF'},

        yaxis: {
          title: 'kWh'
        },

        xaxis: {
          type: 'date',
          autotick: false,
          tick0: 0,
          tickformat: '%b %d', //%Y for year
        },
    };
  } */

  /*this.get_kWh_record = function()
  {
    var today = new Date();

    var data = [{
      x: [],
      y: [],
      name: 'Float',
      type: 'bar',
      marker: {
        color: '#133337',
        opacity: 1,

        line:{width: 1},
        width: 2,
      },
    },
    {
      x: [],
      y: [],
      name: 'Absorb',
      type: 'bar',

      marker: {
        color: '#256645',
        opacity: 1,

        line:{width: 1},
        width: 2,
      },
    },
    {
      x: [],
      y: [],
      name: 'Bulk',
      type: 'bar',

      marker: {
        color: '#113377',
        opacity: 1,

        line:{width: 1},
        width: 2,
      },
    }];

    for(var i = 0; i < 31; i++) //generate 31 days of graph data
    {
      data[0]['x'].push(date_helper(today));
      data[0]['y'].push(Math.floor(Math.random() * 1000) + 1); //generate random data for absorb
      data[1]['x'].push(date_helper(today));
      data[1]['y'].push(Math.floor(Math.random() * 500) + 1); //generate random data for float
      data[2]['x'].push(date_helper(today));
      data[2]['y'].push(Math.floor(Math.random() * 250) + 1); //generate random data for bulk

      today.setDate(today.getDate() - 1); //increment day by one marker
    }

    return data;
  }// End kWh record */
 //end graphing
