function show_modal()
{
  console.log("SHOW MODAL");

  if($("#modal").length == 0)
  {
     $("<ons-modal class='fnor' id='modal' direction='up'><div style='text-align: center'><p><ons-icon icon='md-spinner' size='28px' spin></ons-icon></p><p id='modal_text'></p></div></ons-modal>").appendTo("body");
     $("#modal").show();
  }
  else
  {
    $("#modal").show();
  }
}

function hexStringToString(text_in) //0x20 == std_packet
{
  var text = text_in;
  var text_out = "";

  for(let i = 0; i < text.length; i+=2)
  {
    let char_num = parseInt(text.substring(i, i + 2), 16);

    text_out += String.fromCharCode(char_num);
  }

  return text_out;
}

function cancelable_alert (display_text, id)
{
  ons.notification.alert(display_text);
}

function timeout_hide_modal(text_in, timeout_in)
{
  var text = text_in;
  var timeout = timeout_in;
  update_modal(text);

  setTimeout(()=>{
    hide_modal();
  }, timeout);
}

function update_modal(text)
{
  if($("#modal_text").is(":visible"))
  {
    $("#modal_text").empty();
    $("#modal_text").html(text);
  }
}

function hide_modal()
{
  if($("#modal").length != 0)
  {
    $("#modal_text").empty();
    $("#modal").hide();
  }
}

function byteToHexString(uint8arr) //byte to hex string
{
  if (!uint8arr)
  {
    return '';
  }

  var hexStr = '';

  for (var i = 0; i < uint8arr.length; i++) {
    var hex = (uint8arr[i] & 0xff).toString(16);
    hex = (hex.length === 1) ? '0' + hex : hex;
    hexStr += hex;
  }

  return hexStr.toUpperCase();
}

function extractHexString(hexstring, start, stop, mask)
{
  var sub = "";
  sub = hexsting.substring(start,stop);

  if(mask != 0x00)
  {
    sub = (parseInt(sub, 16) & mask).toString(16);
  }

  return sub;
}

var div_10 = function(data)
{
  if(data != 0)
  {
    return (data / 10);
  }

  return data;
}

var to_int = function(data)
{
  return parseInt(data, 16);
}

var to_int_r = function(data)
{
  var temp = "";

  if(data.length % 2 == 0)
  {
    for(var i = data.length; i >= 2; i = i - 2)
    {
      temp += data.substring(i - 2 , i); //start at the end and work are way toward the beginning of the string
    }
  }
  else
  {
    return "Failed: " + data;
  }

  return parseInt(temp, 16);
}

function local_to_arr8(obj) //same as below but works per
{
  var out = [];
  let keys = Object.keys(obj);
  
  for(let i = 0; i < keys.length; i++)
  {
    out.push(obj[keys[i]]);
  }

  return out;
}

function hexStringToByte(str) //hex to byte array
{
  if (!str) {
    return new Uint8Array();
  }

  var a = [];

  for (var i = 0, len = str.length; i < len; i+=2) {
    a.push(parseInt(str.substr(i,2),16));
  }

  return new Uint8Array(a);
}

function pad(number, length) //pad number with 0's
{
    var str = '' + number;

    while (str.length < length)
    {
        str = '0' + str;
    }

    return str;
}

function p_pad(number, length)
{
  var str = '' + number;

  while (str.length < length)
  {
      str = str + '0';
  }

  return str;
}

var date_helper = function(tomorrow) //convert date to a format plotly likes
{
  var temp = tomorrow.getFullYear();
  temp += "-" + pad(tomorrow.getMonth() + 1, 2);
  temp += "-" + pad(tomorrow.getDate(), 2);

  return temp;
}

var get_mod_id = function(id)
{
  var temp_string = id;
  return temp_string.replace(/:/g, "_");
}

function CRC(buffer)
{
  var crc = 0xFFFF;

  for (var i=0; i<buffer.length; i++)
  {
    crc = Calc_CRC(buffer[i], crc);
  }

    return crc;
}

function Calc_CRC(b, crc)
{
  crc ^= b & 0xFF;

  for (var i=0; i<8; i++)
  {
    var carry = crc & 0x0001;
    crc>>=1;
    if (carry) crc ^= 0xA001;
  }

  return crc;
}

function hex_str_to_big_endian(str_in)
{
  var str = "";

  for(var i = str_in.length; i > 0; i-=2)
  {
    str += str_in.substring(i - 2, i);
  }

  return str;
}

function twoscomp(num_16)
{
  var converted = to_int(num_16);

  if(converted & 0x8000) //negative
  {
    converted = div_10(~(converted ^ 0xFFFF) + 1).toString(); //should get us ~
  }
  else
  {
    converted = div_10(converted).toString();
  }

  return converted;
}

function ten_x_16b(data) //this should be decimal ... outputs hex HHHH (16bit) in ASCII
{
  var x = (data * 10).toString(16).toUpperCase();
  return x;
}

function to_b16(data) //convert int to hex
{
  console.log("B16: " + data);
  var x = parseInt(data).toString(16).toUpperCase();
  return x;
}

function mod_crc(b_array)
{
  var byte_array = b_array;
  var crc = 0xFFFF;

  let TABLE = [
    0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241,
    0xc601, 0x06c0, 0x0780, 0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440,
    0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1, 0xce81, 0x0e40,
    0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841,
    0xd801, 0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40,
    0x1e00, 0xdec1, 0xdf81, 0x1f40, 0xdd01, 0x1dc0, 0x1c80, 0xdc41,
    0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680, 0xd641,
    0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040,
    0xf001, 0x30c0, 0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240,
    0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501, 0x35c0, 0x3480, 0xf441,
    0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
    0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840,
    0x2800, 0xe8c1, 0xe981, 0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41,
    0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1, 0xec81, 0x2c40,
    0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640,
    0x2200, 0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041,
    0xa001, 0x60c0, 0x6180, 0xa141, 0x6300, 0xa3c1, 0xa281, 0x6240,
    0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480, 0xa441,
    0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41,
    0xaa01, 0x6ac0, 0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840,
    0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01, 0x7bc0, 0x7a80, 0xba41,
    0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
    0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640,
    0x7200, 0xb2c1, 0xb381, 0x7340, 0xb101, 0x71c0, 0x7080, 0xb041,
    0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0, 0x5280, 0x9241,
    0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440,
    0x9c01, 0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40,
    0x5a00, 0x9ac1, 0x9b81, 0x5b40, 0x9901, 0x59c0, 0x5880, 0x9841,
    0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81, 0x4a40,
    0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41,
    0x4400, 0x84c1, 0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641,
    0x8201, 0x42c0, 0x4380, 0x8341, 0x4100, 0x81c1, 0x8081, 0x4040
  ];

  for (let index = 0; index < byte_array.length; index++)
  {

    const byte = byte_array[index];
      crc = (TABLE[(crc ^ byte) & 0xff] ^ (crc >> 8)) & 0xffff;
  }

  return crc;
}

/********* UI Framework related stuff ********************************************/

function change_icon(icon_name, id)
{
  var icon = $("#" + id + ''.ons-icon);
  var el = ons.createElement("<ons-icon icon='" + icon_name + "'></ons-icon>");
  icon.replaceWith(el);
}

function ons_createAttach(string_element, target)
{
  //console.log("Attaching: " + string_element);
  var el = ons.createElement(string_element);
  target.append(el);
}

function checkConnection()
{
    var networkState = navigator.connection.type;

    var states = {};
    states[Connection.UNKNOWN]  = {state: false, desc:'Unknown connection'};
    states[Connection.ETHERNET] = {state: true, desc: 'Ethernet connection'};
    states[Connection.WIFI]     = {state: true, desc: 'WiFi connection'};
    states[Connection.CELL_2G]  = {state: true, desc: 'Cell 2G connection'};
    states[Connection.CELL_3G]  = {state: true, desc: 'Cell 3G connection'};
    states[Connection.CELL_4G]  = {state: true, desc: 'Cell 4G connection'};
    states[Connection.CELL]     = {state: true, desc: 'Cell generic connection'};
    states[Connection.NONE]     = {state: false, desc: 'none'};

    return states[networkState];
}

function add_remove_glow(ui_obj)
{
  if(!ui_obj.hasClass("sel_glow_inner")) //add glow and set value to setting
  {
    ui_obj.addClass("sel_glow_inner");
  }
  else
  {
    ui_obj.removeClass("sel_glow_inner");
  }
}
