function can_discovery(dev)
{
  var self = this;
  const timeout = 7500;

  this.device = dev;
  this.client_id = "undefined";
  this.devs_info = {};
  this.d_timeout = "undefined";
  this.uuid = "undefined";
  this.bus_ids = {};
  this.filter = {dev_type: "", bus_id: ""};
  this.home = false;
  this.discovery_type = "long";

  this.init = function(type)
  {
    this.client_id = Math.floor(Math.random() * 125) + 1; //id for rtr
    this.uuid_calc();
    this.start_listen();
    this.discovery_timeout();

    if(type != "")
    {
      this.filter.dev_type = type;
      this.discovery_type = "short";
    }
  }

  this.uuid_calc = function()
  {
    this.uuid = this.device.id.replace(/:/g, '');
    this.uuid = this.uuid.substring(4);
    console.log("UUID: " + this.uuid);
  }

  this.start_listen = function()
  {
    var message_out = {type: "discovery", sub_type: "listen"};
    this.device.context.receive_stream.call(this.device.context, message_out);

    this.devs_info = {};
    this.bus_ids = {};
  }

  this.stop_listen = function()
  {
    this.client_bus_id = this.generate_bus_id();

    var message_out = {type: "discovery", sub_type: "listen_off"};
    self.device.context.receive_stream.call(this.device.context, message_out);
    //this.discovery_send(); //this starts interval to start sendin discovery packets
  }

  this.get_client_id = function()
  {
    return self.client_bus_id;
  }

  this.get_firmware_version = function(bus_id_out)
  {
    ble_client.send_w_threshold({id: self.device.id, command: "", data: canbus.get_meta("3F9", "70", bus_id_out), threshold: 3});
  }

  this.get_device_name = function(which, bus_id_out)
  {
    if(which == 0)
    {
      console.log("CHECK NAME OUT: " + bus_id_out);
      ble_client.send_w_threshold({id: self.device.id, command: "", data: canbus.get_meta("3F7", "70", bus_id_out), threshold: 3});
    }
    else if(which == 1)
    {
      console.log("CHECK NAME OUT: " + bus_id_out);
      ble_client.send_w_threshold({id: self.device.id, command: "", data: canbus.get_meta("3F8", "70", bus_id_out), threshold: 3});
    }
  }

  this.get_attached_uuid = function(bus_id_out) //bluetooth home
  {
    ble_client.send_w_threshold({id: self.device.id, command: "", data: canbus.get_meta("3F7", "6F", bus_id_out), threshold: 3});
  }

  this.discovery_end = function()
  {
    if(this.discovery_timeout)
    {
      clearTimeout(self.d_timeout);
      self.stop_listen();
    }
  }

  this.discovery_timeout = function()
  {
    this.d_timeout = setTimeout(function()
    {
      self.stop_listen();

    }, timeout);
  }

  this.receive_stream = function(message_in)
  {
    var message = "";

    if(this.filter.bus_id != "") //filter on bus_id if defined
    {
        if(message_in.bus_id == this.filter.bus_id)
        {
          message = message_in;
        }
    }
    else
    {
        message = message_in;
    }

    switch(message.register)
    {
      case "3F0":

        if(this.filter.dev_type == "") //normal mass discovery
        {
          this.collect_bus_id(message);
        }
        else if(message.device_type == this.filter.dev_type) //filter by device type
        {
          this.collect_bus_id(message);
        }

      break;

      case "3F7":
        if(message.device_type == "6F") //special case to determine attached unit uuid
        {
          this.process_attached_uuid(message);
        }
        else
        {
          this.process_name(message);
        }
      break;

      case "3F8":
        this.process_name(message);
      break;

      case "3F9":
        this.process_dev_version(message);
      break;
    }
  }

  this.process_dev_version = function(message)
  {
    if(this.bus_ids.hasOwnProperty(message.bus_id)) //check if we have record of bus_id
    {
      if(this.devs_info[this.bus_ids[message.bus_id].uuid].dev_version == "undefined") //assign value to
      {
        let year = parseInt(message.data.substring(0,2),16).toString();
        let month = pad(parseInt(message.data.substring(2,4),16).toString(), 2);
        let debug1 = pad(parseInt(message.data.substring(4,6),16).toString(), 2);
        let debug2 = pad(parseInt(message.data.substring(6),16).toString(), 2);

        let d_version = parseInt(year + month + debug1 + debug2);
        console.log("FIRMWARE VERSION: " + d_version + " Message: " + JSON.stringify(message));
        this.devs_info[this.bus_ids[message.bus_id].uuid].dev_version = d_version;
      }
    }
  }

  this.process_name = function(message) //get device name
  {
    if(this.bus_ids.hasOwnProperty(message.bus_id)) //check if we have record of bus_id
    {
      if(message.register == "3F7")
      {
        if(this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_top == "undefined") //assign value to
        {
          console.log("NAME_TOP: " + JSON.stringify(message));
          this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_top = hexStringToString(message.data);
        }
      }
      else if(message.register == "3F8")
      {
        if(this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_bottom == "undefined") //assign value to
        {
          console.log("NAME_BOTTOM: " + JSON.stringify(message));
          this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_bottom = hexStringToString(message.data);
        }
      }
    }

    if(this.bus_ids[message.bus_id] != undefined)
    {
      if(this.bus_ids[message.bus_id].hasOwnProperty("uuid"))
      {
        if((this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_top != "undefined") && (this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_bottom != "undefined") && (this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name == "undefined"))
        {
          this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name = this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_top + this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name_bottom;
          console.log("NAME: " + this.devs_info[this.bus_ids[message.bus_id].uuid].dev_name + "Dev type: " + this.filter.dev_type);

          if(this.discovery_type == "short") //if short discovery
          {
            this.discovery_end();
          }
        }
      }
    }
  }

  this.process_attached_uuid = function(message)
  {
    if(this.bus_ids.hasOwnProperty(message.bus_id)) //check if we have record of bus_id
    {
      if(!(this.devs_info[this.bus_ids[message.bus_id].uuid].hasOwnProperty("home")))
      {
        if(message.data != "")
        {
          this.devs_info[this.bus_ids[message.bus_id].uuid].home = message.data;
          //this.devs_info[this.bus_ids[message.bus_id].uuid].id = message.id;

          this.home = true;

          if(this.filter.dev_type != "") //if we are in filter mode, set filter to bus id of home message
          {
            console.log("CAN DISCOVERY FILTER ON:" + message.bus_id);
            this.filter.bus_id = message.bus_id;
          }

          console.log("HOME: " + JSON.stringify(this.devs_info[this.bus_ids[message.bus_id].uuid]) + " MESSAGE: " + JSON.stringify(message));
        }
      }
    }
  }

  this.generate_bus_id = function()
  {
    let bus_id = "";

    do
    {
      bus_id = ((Math.floor(Math.random() * 128) + 1)).toString(16); //generate random bus
      console.log("GENEREATED BUS ID: " + bus_id);
    }
    while(this.bus_ids.hasOwnProperty(bus_id));

    console.log("USING BUS ID: " + bus_id);

    return bus_id.toUpperCase();
  }

  this.get_devices_discovered = function()
  {
    let keys = Object.keys(this.devs_info);

    console.log("KEYS: " + JSON.stringify(keys));

    for(let i = 0; i < keys.length; i++)
    {
      if(this.devs_info[keys[i]].dev_name_top == "undefined" || this.devs_info[keys[i]].dev_name_bottom == "undefined")
      {
        this.devs_info[keys[i]].dev_name = "undefined"; //get all of the name or do nothing
      }
    }

    console.log("DISCOVERED: " + JSON.stringify(self.devs_info));
    return self.devs_info;
  }

  this.check_discovered = function(id)
  {
    console.log("DEV: " + this.device.id + " BUS ID: " + id + " STATE: " + this.bus_ids[id].state);

    if(this.bus_ids[id].state == "discovering");
    {
      this.bus_ids[id].state = "undiscovered"; //resend requet(s)
    }
  }

  this.get_home = function(message_in)
  {
    if((message_in.device_type == "14") && !(this.devs_info[this.bus_ids[message_in.bus_id].uuid].hasOwnProperty("home"))) //if MNGP2 ask if home
    {
      this.get_attached_uuid(message_in.bus_id);
    }
  }

  this.check_get_rtrs = function(message)
  {
    var message_in = message;

    if(this.home)
    {
      if(this.bus_ids[message_in.bus_id].state == "undiscovered") //check state of discovery for timeout
      {
        this.bus_ids[message_in.bus_id].state = "discovering";

        setTimeout(()=>{
          self.check_discovered(message_in.bus_id);
        }, 500);
      }

      if((this.filter.dev_type == "") || (this.filter.bus_id != "")) //if we are in regular discovery mode, or home has been found... Find device stuff
      {
        let discovered = true;

        if(this.devs_info[this.bus_ids[message_in.bus_id].uuid].dev_name_top == "undefined")
        {
          discovered = false;
          this.get_device_name(0, message_in.bus_id); //call rtr
        }

        if(this.devs_info[this.bus_ids[message_in.bus_id].uuid].dev_name_bottom == "undefined")
        {
          discovered = false;
          this.get_device_name(1, message_in.bus_id);
        }

        if(this.devs_info[this.bus_ids[message_in.bus_id].uuid].dev_version == "undefined")
        {
          discovered = false;
          this.get_firmware_version(message_in.bus_id);
        }

        if(discovered)
        {
          this.bus_ids[message_in.bus_id].state = "discovered"; //done
        }
      }
    }
    else
    {
      this.get_home(message_in);
    }
  }

  this.collect_bus_id = function(message_in)
  {
    if(message_in.register == "3F0")
    {
      if((this.devs_info[message_in.data.substring(4,12)] == undefined) && (canbus_map.device_types[message_in.device_type] != undefined) && (message_in.data.length >= 7)) //check for existing collected device and if valid device type
      {
        if(message_in.data.length > 12) //3F0 with variant byte
        {
          console.log("Discovery: " + JSON.stringify(message_in));

          if((canbus_map.variant[message_in.device_type] != undefined) && (canbus_map.variant[message_in.device_type][message_in.data.substring(12,14)] != undefined) && (this.bus_ids[message_in.bus_id] == undefined)) //check for old device types and none existent variants
          {
            this.devs_info[message_in.data.substring(4,12)] = {uuid: message_in.data.substring(4,12), bus_id: message_in.bus_id, device_type: message_in.device_type,
              variant: message_in.data.substring(12,14), variant_name: canbus_map.variant[message_in.device_type][message_in.data.substring(12,14)], spec: parseInt(message_in.data.substring(0,2), 16),
              dev_name_top: "undefined", dev_name_bottom: "undefined", dev_name: "undefined", dev_version: "undefined"};

              this.bus_ids[message_in.bus_id] = {uuid: message_in.data.substring(4, 12), state: "undiscovered"}; //bus_id lookup object for rtr assignment and check for conflicting id
          }
        }
      }

      if(this.bus_ids[message_in.bus_id] != undefined) //if we have record, get dev info
      {
        if(this.bus_ids[message_in.bus_id].uuid != undefined)
        {
          this.check_get_rtrs(message_in);
        }
      }
    }
  }
}
