var device_process = {

  device: "undefined",
  to_process: {},

  set_device: function(dev)
  {
    device_process.device = dev;
  },

  set_to_process: function(registers)
  {
    device_process.to_process = registers;
  },

  receive_stream: function(message)
  {
    device_process.process(message);
  },

  process: function(message)
  {
    let keys = Object.keys(device_process.to_process[message.device_type][message.register]); //this matches device_type and register and assigns processing data to message... hopefully

    for(let i = 0; i < keys.length; i++)
    {
      var message_out = "";

      switch(keys[i]) //message function type filter
      {
        case "display":
          //console.log("DISPLAY: " + JSON.stringify(message));
          switch(message.device_type) //register filter
          {
            //META DATA REGISTERS
            case "070": //Register (polling)
            break;

            case "071":
            case "072":
            case "073":
            case "074":
            case "075":

              message.type = "meta";
              message_out = message;
              device_process.device.receive_stream.call(device_process.device, message_out);

            break;

            default:

              message.type = "display";
              message_out = canbus.convert_out(message);
              device_process.device.receive_stream.call(device_process.device, message_out);
          };
        break;

        case "discovery":
          message.type = "discovery";
          message_out = message;
          device_process.device.receive_stream.call(device_process.device, message_out);
        break;

        case "bluetooth":
          message.type = "bluetooth";
          message_out = message;
          device_process.device.receive_stream.call(device_process.device, message_out);
        break;
      };
    }
  }
};
