function mngp2_device(dev)
{
  var self = this;
  this.device = "undefined";
  this.bus_id = "undefined";
  this.settings_menu = "undefined";

  this.interval = "undefined";
  this.notification = false;

  this.viewing = "main" //created for disconnect on hide event
  this.devices = {};
  this.bus_id_lookup = {};

  this.discovery_obj = "undefined";
  this.receive_location = "mngp2";

  //this.toggle = false;

  this.device_process_reg = { //This is used to describe what is displayed

  /*HBAY**********************************/
  "2B": {
    //"021": {none: ["V","A","W"], meta:{}}, //DC OUTPUT AVERAGE
    //"081": {display: ["V", "A", "W"], meta: {post: [" Volts", " Amps", " Watts"], fixed: [2,2,2]}}, //DC INPUT AVERAGE
    //"0A0": {display: ["V", "A", "W"], meta: {fixed: [2,2,2], post: [" Volts", " Amps", " Watts"]}}, //DC CHARGE/DISCHARGE
    //"0A3": {display: ["Charge_stage", "", /*Temp_status*/"",/*Time_in_stage*/"Temperature"], meta: {fixed: ["","","",1], pre: ["", "", "", ""], post: ["", "", "", " &#8451"]}}, //BATTERY STATUS
    //"0A6": {display: [/*Cycle_count*/"", "", /*DOD*/ "SOC"], meta: {pre: ["", "", "SOC"], post: ["","","%"]}}, //BATTERY HEALTH
    //"0A7": {none: ["AH", "" /*WH*/], meta: {post: [" Ah", " KwH"]}}, //BATTERY DC DISCHARGE
    //"0A9": {none: ["Pmax", "Pmin"], meta: {}}, //BATTERY DC PEAK/MIN*/
    //"300": {none: ["V", "A", "W"], meta: {post: [" Volts", " Amps", " Watts"]}}, //AGGREGATE CHARGE/DISCHARGE
    "3F0": {discovery: "process", meta: {}}, //DISCOVERY
    "3F7": {none: ["display_name1"], meta: {}},
    "3F8": {none: ["display_name2"], meta: {}},
    "3F9": {none: ["firmware_version"], meta: {}},
    "480": {config: {meta: {received: false}}}},

  /*MNGP2*********************************/
  "14":
    {"3F0": {discovery: "process"}},

  "2C": {
    //"021": {none: ["V","A","W"], meta:{}}, //DC OUTPUT AVERAGE
    //"081": {display: ["V", "A", "W"], meta: {post: [" Volts", " Amps", " Watts"], fixed: [2,2,2]}}, //DC INPUT AVERAGE
    //"0A0": {display: ["V", "A", "W"], meta: {fixed: [2,2,2], post: [" Volts", " Amps", " Watts"]}}, //DC CHARGE/DISCHARGE
    //"0A3": {display: ["Charge_stage", "", /*Temp_status*/"",/*Time_in_stage*/"Temperature"], meta: {fixed: ["","","",1], pre: ["", "", "", ""], post: ["", "", "", " &#8451"]}}, //BATTERY STATUS
    //"0A6": {display: [/*Cycle_count*/"", "", /*DOD*/ "SOC"], meta: {pre: ["", "", "SOC"], post: ["","","%"]}}, //BATTERY HEALTH
    //"0A7": {none: ["AH", "" /*WH*/], meta: {post: [" Ah", " KwH"]}}, //BATTERY DC DISCHARGE
    //"0A9": {none: ["Pmax", "Pmin"], meta: {}}, //BATTERY DC PEAK/MIN*/
    //"300": {none: ["V", "A", "W"], meta: {post: [" Volts", " Amps", " Watts"]}}, //AGGREGATE CHARGE/DISCHARGE
    "3F0": {discovery: "process"},
    "3F7": {none: ["display_name1"], meta: {}},
    "3F8": {none: ["display_name2"], meta: {}},
    "3F9": {none: ["firmware_version"], meta: {}},
    "480": {config: {meta: {received: false}}}},

  /*Rosie*********************************/
  "30": {
    "3F0": {discovery: "process"},
    //"040": {display: ["V", "A", "Hz"], meta: {post: [" Volts", " Amps", " Hz"], fixed: [2,2,2]}},
    //"041": {display: ["W", "VA"], meta: {fixed: [2,2], post: [" W", " VA"], fixed: [2,2]}},
    //"042": {display: ["VAr", "PF"], meta: {fixed: [2,2], post: [" VAr", " PF"]}},
    //"043": {display: ["V", "A", "Hz"], meta: {fixed:[2,2,2], post: [" Volts", " Amps", " Hz"]}},
    //"044": {display: ["W", "VA"], meta: {post: [" Ah", " KwH"]}},
    //"04A": {display: ["Wh", "Wh"], meta: {post: [" WhA", " WhB"]}},
    //"0A0": {display: ["V", "A", "W"], meta: {fixed: [2,2,2], post: [" Volts", " Amps", " Watts"]}},
    //"0A3": {display: ["Charge_stage", "", "Time_in_stage", "Temperature"], meta: {fixed: ["","","",1], pre: ["", "", "", ""], post: ["", "", "", " &#8451"]}}, //BATTERY STATUS
    //"0C0": {display: ["Status_Errors"], meta: {pre: ["Status: ", "Error: "]}},
    //"0E0": {display: ["Aux Status"], meta: {}},
    //"261": {display: ["Temp", "Temp", "Temp", "Temp"], meta: {fixed: [2,2,2,2], post: [" &#8451", " &#8451", " &#8451", " &#8451"]}},
    "3F9": {none: ["firmware_version"], meta: {}}},
    //"262": {display: ["Temp", "Temp", "Temp", "Temp"], meta: {fixed: [2,2,2,2], post: [" &#8451", " &#8451", " &#8451", " &#8451"]}}},

  /*Bluetooth*****************************/
  "6F": {
    "008": {bluetooth: "process"},
    "009": {bluetooth: "process"}},
}; //this defines what device_process will process and where it goes.

  this.init = function()
  {
    this.device = {context: self, name: "MNGP2", id: dev.id, ser_id: dev.id.replace(/:/g, "_")};

    update_ui.init(self);

    ble.connect(this.device.id, function()
    {
      hide_modal();
      ble_client.send_connected(self.device);
    },
    function()
    {
      hide_modal();
      nav.home();
    });

    devices_instance.send_mtu(this.device.ser_id);

    this.discovery_obj = new can_discovery(self.device);
    this.add_events();

    device_process.set_device(self); //set process_device for message to return to
    device_process.set_to_process(this.device_process_reg);
  }

  this.receive_stream = function(message)
  {
    var message_in = message;

    if(message_in.hasOwnProperty("type"))
    {
      switch(message_in.type)
      {
        case "frame":
          //console.log("Frame: " + JSON.stringify(message_in));
          this.process_frame(message_in);
        break;

        case "display":
          this.display_data(message_in);
        break;

        case "discovery":
          this.process_discovery(message_in);
        break;

        case "connection":
          console.log("Connection: " + JSON.stringify(message_in));
          this.process_connection(message_in.connected);
        break;

        case "mtu":
          console.log("MNGP2 MTU: " +  message_in.value);
        break;

        case "rssi":
          update_ui.update_rssi(message_in.value);
        break;

        case "file_transfer":
          this.process_file_transfer(message_in);
        break;

        case "mngp2":
          this.receive_location = "mngp2";
          console.log("Stream set back to MNGP2");
        break;

        case "meta":
          this.device_process[message_in.device_type][message_in.register].meta = message_in.data;
          console.log("META YO: " + JSON.stringify(this.device_process[message_in.device_type][message_in.register].meta));
        break;

        case "bluetooth":
          console.log("BLUETOOTH: " + JSON.stringify(message_in));
        break;

        default:
          console.log("UNKNOWN STATUS: " + JSON.stringify(message_in));
      }
    }
  }

  this.display_data = function(message)
  {
    if(this.bus_id_lookup.hasOwnProperty(message.bus_id)) //check to see
    {
      switch(message.device_type)
      {
        case "2C":
        case "2B":
        case "30":

          message.uuid = this.bus_id_lookup[message.bus_id];

          if(this.device_process_reg[message.device_type][message.register].hasOwnProperty("display"))
          {
            update_ui.update_device_card(message, this.device_process_reg[message.device_type][message.register]); //messgae and values to display
          }
          else if(this.device_process_reg[message.device_type][message.register].meta.hasOwnProperty("received"))
          {
            console.log("RECEIVED RTR: " + JSON.stringify(message));
            //var message_out = message;
            //message_out.device_type = "71"; //device type for rtr meta request
            //canbus.get_meta(self.device.id, message_out.register, message_out.device_type, message.bus_id);
          }
        break;
      }
    }
  }

  this.process_connection = function(connected)
  {
    if(connected)
    {
      update_ui.update_connection(connected);

      this.interval = setInterval(()=>{
        ble_client.send_rssi(this.device);
      }, 1000);

      ble_client.start_notification(self.device.id, spp.service, spp.rx, "rx_spp");
      ble_client.start_notification(self.device.id, mod.service, mod.receive, "ble_control");

      ble_client.write_wo_response(self.device.id, mod.service, mod.send, control_table.mtu.default)
        .then(()=>{ble_client.write_wo_response(self.device.id, mod.service, mod.send, control_table.firmware_version.request)
          .then(()=>{ble_client.write_wo_response(self.device.id, mod.service, mod.send, control_table.ble_address.request)
              .then(()=>{
                show_modal();
                update_modal("Discovering...");
                self.discovery_obj.init("");
              });
          });
        });
    }
    else
    {
       this.kill();
    }
  }

  this.kill = function()
  {
    if(self.interval)
    {
      console.log("Clear interval");
      clearInterval(self.interval);
    }

    self.discovery_obj.discovery_end();
    hide_modal();

    self.disconnect();
    console.log("FAILED: NOTIFICATION STARTUP");
    nav.home();
  }

  this.set_stream_location = function(loc)
  {
    return new Promise((resolve)=>{
      this.receive_location = loc;
      console.log("Set stream location to: " + loc);
      resolve();
    });
  }

  this.process_frame = function(message)
  {
    switch(this.receive_location)
    {
      case "mngp2": //basiclly all traffic
        if(self.device_process_reg[message.device_type] != undefined && self.device_process_reg[message.device_type].hasOwnProperty(message.register)) //only process frames in device_process_reg
        {
          device_process.receive_stream(message);
        }
      break;

      case "discovery": //traffic for discovery process ()
        this.discovery_obj.receive_stream(message);
      break;

      case "firmware_update":
        firmware_update.receive_stream(message);
      break;

      case "file_transfer": //traffic for file transfer (firmware update)
        file_transfer.receive_stream(message);
      break;
    }
  }

  this.process_file_transfer = function(message_in)
  {
    switch(message_in.subtype)
    {
      case "transfer":
        self.receive_location = "file_transfer";
      break;

      case "transfer_off":
        self.receive_location = "mngp2";
      break;
    }
  }

  this.process_discovery = function(message_in)
  {
    if(message_in.hasOwnProperty("sub_type"))
    {
      switch(message_in.sub_type)
      {
        case "listen":
          self.receive_location = "discovery";
        break;

        case "listen_off":
          hide_modal();
          self.receive_location = "mngp2";
          this.bus_id = self.discovery_obj.get_client_id();
          this.devices = self.discovery_obj.get_devices_discovered();
          //ble_client.write_wo_response(self.device.id, mod.service, mod.send, control_table.ble_force_on.request);  //this will force on ble even if mngp2 says to shut off

          console.log("DEVICES: " + JSON.stringify(this.devices));

          this.generate_devices();
          /*SET UUID -----------TESTING------------ */
          //ble_client.send_w_threshold({id: self.device.id, command: "now", threshold: 1, data: canbus.construct_frame({serial_bits: "010", register: "540", device_type: "14", index: "0", bus_id: "3E", dlc: 4, data: "00000042"})});
        break;
      }
    }
    else //non discovery status frames (3F0)
    {
      if(message_in.register == "03F") //update 03F (spec)
      {
        let spec = parseInt(message_in.data.substring(0,2), 16);
        let uuid = message_in.data.substring(4,12);

        if(this.devices[uuid] != undefined)
        {
          if(this.devices[uuid].spec != spec)
          {
            this.devices[uuid].spec = spec;
          }
        }
      }
    }
  }

  this.generate_devices = function()
  {
    var device_keys = Object.keys(this.devices);

    for(var i = 0; i < device_keys.length; i++)
    {
      var dev_info = this.devices[device_keys[i]]; //{type: canbus_map.device_types[devices[i]], id: id, bus_id: canbus_map.device_types[devices[device_keys[i]]]};
      console.log("DEV: " + JSON.stringify(dev_info));

      update_ui.generate_device_card(dev_info);

      this.bus_id_lookup[this.devices[device_keys[i]].bus_id] = this.devices[device_keys[i]].uuid; //simple lookup to equate bus_id to uuid

      var dev_btn_query = $("#card_device_" + dev_info.uuid);
      this.add_device_button_handler(dev_btn_query, dev_info);
    }

    console.log(JSON.stringify(self.bus_id_lookup));
  }

  this.add_device_button_handler = function(dev_btn, dev) //for testing mostly
  {
    var device_in = dev;

    console.log("DEV: " + JSON.stringify(device_in));

    dev_btn.on("click", {value: canbus_map.device_types[device_in.device_type]}, (event)=>
    {
      show_modal();
      update_modal("Starting update...");
      firmware_update.init(self, self.device, self.bus_id, device_in);
      self.receive_location = "firmware_update";
    });
  }

  this.control_in = function(current_response) //ble module control characteristic incoming --- control is a seperate service logically seperating serial bridge
  {
    switch(current_response.substring(0,4))
    {
        case "BE10":
          if(self.receive_location == "file_transfer")
          {
            file_transfer.receive_stream({type:"filter", message: current_response});
          }
          else if(self.receive_location == "firmware_update")
          {
            firmware_update.receive_stream({type:"filter", message: current_response});
          }
        break;
    }

    console.log("CONTROL: " + current_response + " Location:" + self.receive_location);
  }

  this.connect = function()
  {
    ble.isConnected(self.device.id, function()
    { //if connected
      console.log("MNGP2 connected");
    },
    function()
    {
      ble.connect(self.device.id, ()=>{
        console.log("MNGP2 connected");
      });
    });
  }

  this.disconnect = function()
  {
    ble.isConnected(self.device.id, function()
    { //if connected
      ble.disconnect(self.device.id, ()=>{
        console.log("MNGP2 disconnected");
      });
    },
    function()
    {
      console.log("MNGP2 disconnected");
    });
  }

  this.spp_in = function(current_response) //receive serial data
  {
    self.raw_can = current_response;
    canbus.parse_canbus(self.raw_can, self.device);
  }

  this.add_events = function()
  {
    $("#devices_button").one("click", function(event) //this is for speed dial buttons
    {
      nav.home();
    });

    $("#update_icon_" + self.device.ser_id).on("click", ()=>
    {
      if($("#generic_dialog").length == 0) //Don't change this dumbass... this removes any previous generic dialogs from DOM
      {
        console.log("LOADING DEVICE LIST");
        self.viewing = "device_list_dialog";
        ons.createDialog("/android_asset/www/templates/generic_dialog.html");
        dev_update_ui.init();
      }
    });

    $("#device_page").on("hide", function()
    {
        self.discovery_obj.discovery_end();

        if(self.viewing == "main")
        {
          ble_client.disconnect(self.device);
        }
    });

    var page = page_navigator.topPage;

    page.onDeviceBackButton = function(event)
    {
      self.disconnect();
      //discovery_obj.discovery_end();
      page_navigator.resetToPage("/android_asset/www/templates/home.html")
      .then(()=>{
        landing_page.init();
      });
    }

    $("#back_arrow").one("click", function()
    {
      self.disconnect();
      console.log("BACK!!!");
      nav.home();
    });
  }
}
