var landing_page =
{
  init: function()
  {
    var scan_list = document.getElementById('scan_list');
    //var update_menu = document.getElementById('update_menu');
    var settings_menu = document.getElementById('settings_menu');
    var speed_dial = document.getElementById('speed_dial');

    //file_management.load_firmware_map();
    //file_management.remote_map_mod_date();

    //*************************************************************
    $("#ble_scan_icon, #settings_icon, #update_icon").on("click", function() //this is for speed dial buttons
    {
      switch($(this).attr("id"))
      {
        case "ble_scan_icon":

          scanner.init("main", "ble_scan_icon");

        break;

        case "settings_icon":

          settings.init();
          settings_menu.show();

        break;

        case "update_icon":

          let advertising = scanner.get_advertising();

          if(advertising == 0)
          {
            scanner.init("update", "");
          }
          else
          {
            update.init("single");
          }

        break;
      }
    });

    $("#landing_page").on('show', ()=>
    {
      console.log("Scan postshow");
      scanner.reset();

      if(!ble_client.check_scanning())
      {
        ble_client.scan();
      }
    });

    $("#landing_page").on("hide", ()=>
    {
      console.log("SCAN POSTHIDE");

      if(scanner.type == "main" && ble_client.check_scanning())
      {
        ble_client.stop_scan();
      }

      $("#scan_list").empty();

      clearInterval(scanner.interval);
      document.getElementById('speed_dial').show();
      scanner.reset();
    });

    $("#update_menu, #settings_menu").on("postclose posthide", function()
    {
      document.getElementById('speed_dial').show();
    });

    $("#update_menu, #settings_menu").on("preopen preshow", function()
    {
      document.getElementById('speed_dial').hide();
    });
  },

  receive_input: function(message_in)
  {
    console.log("Here is the input: " + JSON.stringify(message_in));
  },
}
