var settings = {

  init: function()
  {
    var el = ons.createElement("<ons-list id='settings_list'><ons-list-header>Settings</ons-list-header></ons-list>");
    $("#settings_dialog").append(el);
    var list = $("#settings_list");
    var saved_settings = app_config.get_settings();

    console.log("Initial mode: " + JSON.stringify(saved_settings));

    if(saved_settings.mode == "dark")
    {
      console.log("dark_mode");
      el = ons.createElement("<ons-list-item>Dark mode<div class='right'><ons-switch id='dark_mode' checked='true' class='flex-new-row'></ons-switch></div></ons-list-item>");
    }
    else
    {
      console.log("light_mode");
      el = ons.createElement("<ons-list-item>Dark mode<div class='right'><ons-switch id='dark_mode' class='flex-new-row'></ons-switch></div></ons-list-item>");
    }

    list.append(el);
    //el = ons.createElement("<ons-list-item>About</ons-list-item>");
    //list.append(el);

    settings.add_events();
  },

  add_events: function()
  {
    $("#dark_mode").on("change", function(event)
    {
      if($("#dark_mode").prop("checked") == true)
      {
        app_config.set_settings({mode:"dark"});
        app_ui_mode = "dark";
        document.querySelector('#theme').setAttribute('href', 'css/dark-onsen-css-components.min.css');
        StatusBar.backgroundColorByHexString("#000000");
        NavigationBar.backgroundColorByHexString("#000000", false);
      }
      else
      {
        app_config.set_settings({mode:"light"});
        app_ui_mode = "light";
        document.querySelector('#theme').setAttribute('href', 'css/onsen-css-components.min.css');
        StatusBar.backgroundColorByHexString("#EBEFF1");
        NavigationBar.backgroundColorByHexString("#EBEFF1", true);
      }
    });

    $("#settings_menu").one("posthide", ()=>
    {
      console.log("Empty list");
      $("#settings_dialog").empty();
    });
  }
}
