var settings_dialog = {

  settings_obj: undefined,
  dialog: undefined,
  content: undefined,
  ser_id: undefined,
  input_type: undefined,
  value: undefined,
  changed: false,

  //{type:"select", title:"Pick firmware", loc: "ota_update", value: "", changed:false, list:["MNGP2", "MNGP20", "MNBC"]}... FYI

  open_dialog: function(id, settings_obj)
  {
    return new Promise((resolved)=>
    {
      if($("#generic_dialog").length > 0) //Don't change this dumbass... this removes any previous generic dialogs from DOM
      {
        $("#generic_dialog").remove();
      }

      settings_dialog.settings_obj = settings_obj;
      settings_dialog.settings_obj.new_value = "";
      settings_dialog.ser_id = id;
      settings_dialog.input_type = settings_dialog.settings_obj.type;
      settings_dialog.value = undefined;
      settings_dialog.changed = false;

      nav.dialog()
        .then(function(dialog)
        {
          settings_dialog.dialog = $("#generic_dialog");
          settings_dialog.content = $("#dialog_content");
          settings_dialog.create_content();

          settings_dialog.dialog.one("posthide hide", ()=> //for cancel without button
          {
            console.log("DIALOG HIDE");

            settings_dialog.content_removed()
             .then((message)=>
             {
               resolved(message);
             });
          });
        });
      });
    },

    create_content: function() //init
    {
      ons_createAttach("<div><ons-toolbar inline><div class='left'><ons-icon size='2x' icon='md-settings' style='padding-left:3vw;'</ons-icon></div><div class='center'>" + settings_dialog.settings_obj.title + "</div>\
      </ons-toolbar></div>", settings_dialog.content);
      settings_dialog.set_mode();
      settings_dialog.dialog.show();
    },

    content_removed: function()
    {
      return new Promise((resolve)=>
      {
        switch(settings_dialog.input_type)
        {
          case "select":
            settings_dialog.value = $("#gen_input").val();

            if(settings_dialog.settings_obj.value != settings_dialog.settings_obj.list[settings_dialog.value])
            {
              settings_dialog.changed = true;
            }
          break;

          case "switch":
            settings_dialog.value = $("#gen_input").prop("checked");
          break;

          case "list":
            settings_dialog.value = settings_dialog.settings_obj.new_value; //not sure, smoked too much crack or something...
          break;

          default:
            settings_dialog.value = $("#gen_input").val();

          if(settings_dialog.settings_obj.value != settings_dialog.value)
          {
            settings_dialog.changed = true;
          }
        } //end switch

        settings_dialog.settings_obj.new_value = settings_dialog.value; //user input to new value

        settings_dialog.return()
          .then((message)=>
          {
            resolve(message)
          });
      });
    },

    return: function()
    {
      var message_out = settings_dialog.settings_obj;

      return new Promise((resolve)=>
      {
        switch(settings_dialog.settings_obj.loc)
        {
          case "ota_update":
            ota_update.receive_input(message_out);
            resolve(message_out);
          break;

          case "landing_page":
            landing_page.receive_input(message_out);
            resolve(message_out);
          break;

          default:
            if((settings_dialog.changed || settings_dialog.settings_obj.new_value == "cancel") && settings_dialog.settings_obj.new_value != "") //If the value has changed... send it out
            {
              devices_instance.send_status(settings_dialog.ser_id, {type: "user_settings_input", message: message_out});
              resolve(message_out);
            }
         }
      });
    },

    set_mode: function()
    {
      if(settings_dialog.settings_obj.set != undefined)
      {
        settings_dialog.content.append("<div id='gen_value' style='padding-top:2vh' class='generic-dialog'>" + settings_dialog.settings_obj.set + /*"" + modbus_map[settings_dialog.settings_obj.reg].attr[0] + */"</div>");
      }

      switch(settings_dialog.input_type)
      {
        case "list":
          let list_items = settings_dialog.create_list_items(settings_dialog.settings_obj.list);
          ons_createAttach("<ons-list>" + list_items + "</ons-list>", settings_dialog.content);
        break;

        case "binary_choice": //simple yes or no dialog

          let choices = settings_dialog.create_choices(settings_dialog.settings_obj.choices);
          ons_createAttach("<div class='flex-new-row'>" + choices + "</div>", settings_dialog.content);

        break;

        case "integer":

          ons_createAttach("<div class='flex-new-row'><ons-input id='gen_input' type='number'></ons-input></div>", settings_dialog.content);

        break;

        case "float":

          ons_createAttach("<div class='flex-new-row'><ons-input id='gen_input' type='number'></ons-input></div>", settings_dialog.content);

        break;

        case "switch":

          ons_createAttach("<div class='flex-new-row'><ons-switch id='gen_input' size='3x'></ons-switch></div>", settings_dialog.content);

        break;

        case "select":

          let options = settings_dialog.create_options(settings_dialog.settings_obj.list);
          ons_createAttach("<div class='flex-new-row'><ons-select id='gen_input' onchange=''>" + options + "</ons-select></div>", settings_dialog.content);

        break;

        case "range":

          ons_createAttach("<div class='generic-dialog fnor' style='align-content:center;'><ons-range id='gen_input' style='width:65%'\
           min='" + settings_dialog.settings_obj.min + "' max='" + settings_dialog.settings_obj.max + "'\
           step='" + settings_dialog.settings_obj.step + "'></ons-range></div>", settings_dialog.content);

          $("<span style='padding-right:2vw'>" + settings_dialog.settings_obj.min + "</span>").insertBefore("#gen_input");
          $("<span style='padding-left:2vw'>" + settings_dialog.settings_obj.max + "</span>").insertAfter("#gen_input");

        break;
      }

      settings_dialog.content.append("<div id='ok_cancel'style='display:flex;flex-direction:row;flex-basis:100%;'><div style='flex: 0 0 40%'></div></div>");
      ons_createAttach("<ons-button style='flex: 1 0 0;justify-content:flex-end' id='gen_ok' modifier='large--quiet'>OK</ons-buttons", $("#ok_cancel"));
      ons_createAttach("<ons-button style='flex: 3 0 0;justify-content:flex-end' id='gen_cancel' modifier='large--quiet'>Cancel</ons-buttons", $("#ok_cancel"));
      settings_dialog.add_dialog_events();
    },

    add_dialog_events: function()
    {
      $("#gen_cancel").one("click", ()=>
      {
        settings_dialog.settings_obj.new_value = "cancel";
        settings_dialog.dialog.hide();
        settings_dialog.dialog.trigger("posthide");
      });

      $("#gen_ok").one("click", ()=>
      {
        settings_dialog.dialog.hide();
        settings_dialog.dialog.trigger("posthide");
      });

      switch(settings_dialog.input_type)
      {
        case "range":
        {
          var slider = $("#gen_input");

          slider.on("input", function()
          {
            console.log("Sliding: " + slider.val());
            $("#gen_value").html(slider.val() + "" + modbus_map[settings_dialog.settings_obj.reg].attr[0]);
          });
        }

        break;

        case "select":
        {
          $("#gen_input").on("onChange", function(){
            settings_dialog.value = this.val();
          });
        }

        break;

        case "list":

          for(let i = 0; i < settings_dialog.settings_obj.list.length; i++)
          {
              $("#list_" + i).on('click', (e)=>
              {
                var this_id = e.currentTarget.id;

                console.log("Clicked id: " + this_id);

                if($("#" + this_id).hasClass("sel_glow_inner")) //toggle state
                {
                  add_remove_glow($("#" + this_id)); //glow
                  settings_dialog.settings_obj.new_value = ""; //reset value to nothing
                }
                else //set
                {
                  settings_dialog.check_glow_reset(settings_dialog.settings_obj.list); //reset all list items if they glow
                  add_remove_glow($("#" + this_id)); //glow
                  settings_dialog.settings_obj.new_value = $("#" + this_id).text();
                }
              });
          }
         break;
      }//end switch
    },

    create_options: function(options)
    {
      let i;
      var options_string = "";

      for(i = 0; i < options.length; i++)
      {
        if(options[i] != "NA") //solved reserved gaps in enums
        {
          options_string += "<option value='" + i + "'>" + options[i] + "</option>";
        }
      }

      return options_string;
    },

    create_choices: function(choices)
    {
      for(let i = 0; i < choices.length; i++)
      {
        console.log("Buttons: " + choices[i]);
      }
    },

    create_list_items: function(list)
    {
      var list_items = "";

      for(let i = 0; i < list.length; i++)
      {
        list_items += "<ons-list-item id='list_" + i + "'>" + list[i] + "</ons-list-item>";
      }

      return list_items;
    },

    check_glow_reset: function(id_array)
    {
      for(let i = 0; i < id_array.length; i++)
      {
        if($("#list_" + i).hasClass("sel_glow_inner")) //if glow, remove
        {
          add_remove_glow($("#list_" + i));
        }
      }
    },
}
