var update = {

update_type: "", //single or system

 init: function(type)
 {
   update.update_type = type;

   console.log("Update: " + update.update_type);

   ble_client.check_ble_loc()
      .then(function(ble_loc_state) //check location and data settings
      {
        if(ble_loc_state)
        {
          update.check_connection() //check data connection for firmware download
            .then(function(data_state)
            {
              if(data_state) //if we have data connection
              {
                if(update.update_type == "single")
                {
                  update.add_events(); //lets do some stuff
                  update.create_list();
                }
                else //not single... must be system
                {
                    //call functions to check external firmware repo and cross check local
                    alert(JSON.stringify(update.get_ftp_listing()));
                }
              }
              else //call function to ask if we want to continue with local copy
              {
                //check for local copy... if no. Alert for data connection else prompt newer update on local storage
                var update_dialog_string = {type:"binary", title: "", loc: "system_update", value: "", changed:false, message:["Local firmware found. Would you like to continue?"]};
                settings_dialog.open_dialog("update", "What what?");
              }
            });
         }
    });
  },

  get_ftp_listing: function()
  {
    ftp_client.connect()
      .then((connected)=>{
        if(connected)
        {
          return ftp_client.list();
          ftp_client.disconnect();
        }
        else
        {
          alert("SHIT FAILED");
          console.log("SHIT FAILED"); //so unprofessional... good
        }
      });
  },

  receive_input: function(dialog_input)
  {
    console.log("Update dialog input: " + JSON.stringify(dialog_input));
  },

  check_connection: function()
  {
    return new Promise(function(resolve)
    {
      var con_obj = checkConnection();

      if(!(con_obj.state))
      {
        ons.notification.alert("You need to connect to the internet to download firmware");
        resolve(false);
      }
      else
      {
        resolve(true);
      }
    });
  },

/*  add_device_to_list: function(device_in) //used to add devices to list
  {
    var device = device_in;

    if(device.id)
    {
      let list = $("#update_device_list");
      let el;
      let name_label = "";

      console.log("Adding: " + device.id + " to update list");

      if(device.hasOwnProperty("ser_id"))
      {
        if(device.hasOwnProperty("user_name")) //fix bug that causes update to fail with wrong device name
        {
          name_label = device.user_name;
        }
        else
        {
          name_label = device.name;
        }

        el = ons.createElement("<ons-list-item class='flex-new-row' id='update_" + device.ser_id + "'>" + name_label + " " + device.id + "</ons-list-item>");
      }
      else
      {
        el = ons.createElement("<ons-list-item class='flex-new-row' id='update_" + device.id + "'>" + name_label + " " + device.id + "</ons-list-item>");
      }

      list.append(el);
      update.add_click(list, device);
    }
  },

  add_click: function(list, device)
  {
    list.one('click', '#update_' + device.ser_id, function(e)
    {
      update.fire_dialog(device);
    });
  },

  */

  fire_dialog: function(device_in) //wam bam update plan
  {
    var device = device_in;

    ons.createDialog("/android_asset/www/templates/update.html")
      .then(function(dialog)
      {
        ota_page.init(device);
        $("#update_menu").hide();
        dialog.show();
      });
  },

/*  display_update_menu: function()
  {
    ons_createAttach("<ons-list id='update_device_list'><ons-list-header>Update BLE</ons-list-header></ons-list>", $("#update_dialog"));
    update_menu.show(); //this is from landing page
  },

  create_list: function() //populate list with devices already discovered
  {
    var keys = Object.keys(devices_instance.devices_obj);

    if(keys.length == 0) //nothing connected or scanible to update
    {
      if(scanner.get_scan_count() ==  0)
      {
        ons.notification.alert("Nothing to update");
      }
    }
    else
    {
      var advertising = scanner.get_advertising();

      console.log("Update list: " + JSON.stringify(advertising));

      update.display_update_menu();

      advertising.forEach(update.add_device_to_list);

      for(let i = 0; i < keys.length; i++)
      {
        ble.isConnected(devices_instance.devices_obj[keys[i]].id, ()=>{
          update.add_device_to_list(devices_instance.devices_obj[keys[i]]);
        });
      }
    }
  }, */

  add_events: function()
  {
    $("#update_menu").one("preshow", ()=>
    {
      document.getElementById('speed_dial').hide();
    });

    $("#update_menu").one("posthide", ()=>
    {
      $("#update_dialog").empty();
      document.getElementById('speed_dial').show();
    });
  }
}
