var spp = { //THIS IS GLOBAL!!!
  service: "6830B783-2CAA-4E92-BC46-1978DA85F645",
  rx: "D04DDAF9-DE59-4C72-B0E7-2D6B26567EE4",
  tx: "EE25F7D7-75C8-45EA-8A58-16431DA38001"
};

var mod = {
  service: "52B6DE55-6D37-42B5-A69F-BE3941F74CCC",
  send: "2D69D29F-2E07-45C3-9E27-5B50FD4D46C4",
  receive: "464E3738-1BC6-4f40-90EA-2AAC4Bf7C9B4"
};

var ota_gatt =
{
  service: "1D14D6EE-FD63-4FA1-BFA4-8F47B42119F0",
  control: "F7BF3564-FB6D-4E53-88A4-5E37E0326063",
  data:    "984227F3-34FC-4045-A5D0-2C581F81A153",
  bootloader_version: "25f05c0a-e917-46e9-b2a5-aa2be1245afe",
  apploader: "4f4a2368-8cca-451e-bfff-cf0e2ee23e9f",
  ota_version: "4cc07bcf-0868-4b32-9dad-ba4cc41e5316",
  application_version: "0d77cc11-4ac1-49f2-bfa9-cd96ac7a92f8"
};

var ble_client = {

  scanning: false,

  init: function()
  {
    ble_client.send_buffer = {};
  },

  scan: function()
  {
    ble_client.scanning = true;

    console.log("Scan started");
    devices_instance.reset_discovery(); //reset chronological discovery before scanning

    ble.startScan([], function(scan_device)
    {
      let dev_list = {};

      if(scan_device.name == "MNGP2" || scan_device.name == "OTA") //only show detected Midnite devices
      {
        if(dev_list.hasOwnProperty(scan_device.id) == false) //check if we have a record of device
        {
          dev_list[scan_device.id] = scan_device.id;
          console.log("Calling discovery on: ", scan_device.id);
          devices_instance.device_discovery(scan_device);
        }
      }
    });
  }, //end scan

  stop_scan: function()
  {
    ble_client.scanning = false;

    return new Promise((resolve)=>{

      ble.stopScan(()=>
      {
        console.log("Scan Stopped");
        resolve();
      });
    });
  }, //end stop_scan

  check_scanning: function()
  {
    return ble_client.scanning;
  },

  send_connected: function(dev)
  {
    var device = dev;

    if(devices_instance.exists(device))
    {
      ble.isConnected(device.id, function()
      {
        devices_instance.send_status(device.ser_id, {type: "connection", connected: true});
      },
      function()
      {
        devices_instance.send_status(device.ser_id, {type: "connection", connected: false});
      });
    }
  },

  send_rssi: function(dev)
  {
    var device = dev;

    ble.readRSSI(device.id, function(rssi)
    {
      devices_instance.send_status(device.ser_id, {type: "rssi", value: rssi});
    });
  },

  connect: function(dev) //toggle connect and disconnect
  {
    var device = dev;

    return new Promise((resolve)=>{

      ble.connect(device.id, function() //bluetooth api funcion
      {
        if(devices_instance.exists(device))
        {
          ble.requestMtu(device.id, 247, function()
          {
            devices_instance.set_mtu(device.ser_id, 244);
            resolve(true);
          },
          function(e)
          {
            devices_instance.set_mtu(device.ser_id, 20); //default
          });

          devices_instance.set_connected(device.ser_id, true);
          scanner.scan_list_state_change(device, "connected");
        }
      },
      function(e) //disconnect
      {
        if(devices_instance.exists(device))
        {
          devices_instance.set_connected(device.ser_id, false);
          scanner.scan_list_state_change(device, "disconnected");
          devices_instance.set_mtu(device.ser_id, undefined);
          resolve(false);
        }
      });
    });
  },

  disconnect: function(dev)
  {
    return new Promise((resolve)=>{
      ble.disconnect(dev.id, function()
      {
        if(devices_instance.exists(dev) && dev.ser_id != undefined)
        {
          devices_instance.set_connected(dev.ser_id, false);
          scanner.scan_list_state_change(dev, "disconnected");
          devices_instance.set_mtu(dev.ser_id, undefined);
          resolve(true);
        }
      }, ()=>{resolve(false)});
    });
  },

  start_notification: function(id, service, char, type)
  {
      var type = type;

      console.log("start notification: " + type + " : " + id);

      if(type == "raw")
      {
        service = spp.service;
      }
      else if(service === spp.service) //this regular passthrough serial data
      {
        type = "rx_spp";
      }
      else if(service === mod.service)
      {
        type = "ble_control";
      }

      ble.startNotification(id, service, char, function(data_in) //get notification and send to proper device
      {
          devices_instance.send_notification(id, byteToHexString(new Uint8Array(data_in)), type);
      },
      function(e)
      {
        console.log("Failed to register: " + service + "Error: " + e);
      });
  },

  stop_notification: function(id, service, char)
  {
    ble.stopNotification(id, service, char, function()
    {
      console.log("Notification stopped: " + id);
    });
  },

  write_wo_response: function(id, service, characteristic, to_send)
  {
    var uint8_buffer = hexStringToByte(to_send); //convert hex string into byte array

      return new Promise((resolve)=>
      {
       if(to_send != "")
       {
         ble.writeWithoutResponse(id, service, characteristic, uint8_buffer.buffer, function()
         {
           console.log("Sent: " + id + " : " + JSON.stringify(to_send));
           resolve(true);
         },
         function(e)
         {
           console.log("Failure to send data to BLE device: " + JSON.stringify(e));
           resolve(false);
         }); //end writeWithoutResponse
       }
       else
       {
          resolve(false);
       }
      });
  },

  send_w_threshold: function(req) //this also removes duplicate requests
  {
    let request = req;

    if(!(request.id in ble_client.send_buffer))
    {
      ble_client.send_buffer[request.id] = {count: 0, command: request.command, data_array: [], data: "", threshold: request.threshold};
    }

    if(ble_client.send_buffer[request.id].data_array.indexOf(request.data))
    {
      ble_client.send_buffer[request.id].count++;
    }
    else(ble_client.send_buffer[request.id].data_array.length)
    {
      ble_client.send_buffer[request.id].data += request.data;
      ble_client.send_buffer[request.id].count++;
    }
    console.log("SEND_BUFFER: " + JSON.stringify(ble_client.send_buffer));

    if(ble_client.send_buffer[request.id].threshold <= ble_client.send_buffer[request.id].count || request.command == "now")
    {
      console.log("WRITE WITH THRESHOLD");
      ble_client.write_wo_response(request.id, spp.service, spp.tx, ble_client.send_buffer[request.id].data)
        .then(()=>{
          ble_client.send_buffer[request.id].data_array = [];
          ble_client.send_buffer[request.id].data = "";
          ble_client.send_buffer[request.id].count = 0;
        });
    }
  },

  write_w_response: function(id, service, characteristic, to_send)
  {
    var uint8_buffer = hexStringToByte(to_send); //convert hex string into byte array

    return new Promise((resolve)=>
    {
      ble.write(id, service, characteristic, uint8_buffer.buffer, function(w)
      {
        console.log("Sent_write_with_response: " + id + " : " + JSON.stringify(w));
        resolve(true);
      },
      function(e)
      {
        console.log("Failure to send data to BLE device: " + JSON.stringify(e));
        resolve(false);
      });
    });
  },

  ble_enabled: function()
  {
    return new Promise(function(resolve)
    {
      ble.isEnabled(()=>{resolve(true)},
      ()=>{
        ons.notification.alert("Please enable Bluetooth");
        resolve(false);
      });
    });
  },

  location_enabled: function()
  {
    return new Promise(function(resolve)
    {
      ble.isLocationEnabled(function()
      {
        resolve(true);
      },
      function()
      {
        ons.notification.alert("Please enable location");
        resolve(false);
      });
    });
  },

  check_ble_loc: function()
  {
    return new Promise(function(resolve)
    {
      ble_client.ble_enabled().then(function(ble_state)
      {
        if(!ble_state)
        {
          console.log("BLE not enabled");
          resolve(false);
        }
        else
        {
          ble_client.location_enabled().then(function(loc_state)
          {
            if(!loc_state)
            {
              resolve(false);
            }
            else
            {
              resolve(true); //this is the one
            }
          });
        }
      });
    });
  },

  connect_and_send_w: function(id, service, characteristic, to_send) //why not? Connect once, send and disconnect
  {
    ble.connect(id, function() //success
    {
      var uint8_buffer = hexStringToByte(to_send); //convert hex string into byte array

      ble.write(id, service, characteristic, uint8_buffer.buffer, function()
      {
        console.log("Sent_write_with_Notification and disconnect: " + id + " : " + JSON.stringify(to_send));
      },
      function(e)
      {
        console.log("Failed to write: " + JSON.stringify(e));
      });

      ble.disconnect(id);
    },
    function(e)
    {
      console.log("Failed to connect: " + JSON.stringify(e));
    });
  },

  std_packet: function(device)
  {
    return new Promise ((resolve)=>{ble_client.write_wo_response(device.id, mod.service, mod.send, control_table.can_filter.default); resolve()});
  },

  filter_packet: function(device, filter)
  {
    return new Promise ((resolve)=>{ble_client.write_wo_response(device.id, mod.service, mod.send, control_table.can_filter.request + filter); resolve();});
  },
};
