var control_table = {
  serial: {request: "BE00", default: "01"},
  firmware_version: {request: "BE01"}, //returns I2C bus speed... only used for testing in a past life
  module_temp: {request: "BE02"}, //Gets temperature from ble module
  write_eeprom: {request: "BE03"}, //Write to EEPROM on ble modules
  read_eeprom: {request: "BE04"}, //Read value from EEPROM
  BE05: {no: "NO"}, //Send configuration data to BLE... NOT USED
  blinky: {on: "BE0603", off: "BE0600"}, //Blinky, 02 is valid, but I don't know if it works anymore
  del_eeprom: {request: "BE07"}, //Delete EEPROM/Format
  stream_control: {start: "BE0801", stop: "BE0800"},//Start and stop stream
  stream_interval: {default: "BE0900C8"}, //set interval for streaming modbus read requests from ble module
  reboot: {request: "BE0AFD"}, //Not sure if still works, may hang/crash module... GL
  stream_registers: {request: "BE0B", default: "BE0B100417102301111203104302"},
  RTCC_setup: {request: "BECC"}, //To be continued... maybe
  mtu: {request: "BE0F", default: "BE0FF4"}, //set mtu
  can_filter: {request: "BE10", default: "BE1000"}, //set rx incoming can filter
  ble_address: {request:"BE0E"},
  ble_force_on: {request: "BE1A01"}
}

function ble_module_control(dev)
{
  var self = this;
  this.device = dev; //we need cheap access to ser_id
  this.in_process = false;
  this.last_control = "undefined";
  this.in_position = 0;
  this.message_in = {};
  this.message_in.sub_type = "";
  this.date = new Date();

  this.process_input = function(data, id) //This takes all incoming control packets and routes them to there appropriate processors
  {
    //console.log("Data in: " +  data);

    if(this.in_process == false && data.substring(0, 2) == "BE") //we are processing a new message
    {
      var control_command = data.substring(0, 4); //this is header for the response which is also the specific command sent (BE04, BE05, BE06)

      switch(control_command)
      {
        case "BE02":
        {
          var mod_temp = parseInt(data.substring(4), 16);
          devices_instance.send_status(this.device.ser_id, {type: "mod_temp", value: mod_temp});
        }
        break;

        case "BE04": //this response is reading from persistent memory
        { //HHHH LL AAAA
          this.message_in.message = ""; //reset
          this.in_process = true;
          this.message_in.id = id;
          this.message_in.type = control_command;
          this.message_in.address = data.substring(6,10); //BE04 00 0000
          this.message_in.length = 0;
          this.process_message(data);
          break;
        }
        case "BE0D": //this is for the RTCC
        {
          this.process_time(data);
        }
        break;

        case "BE03": //this is the success response for write command (hopefully)
        {
          this.message_in.message = data;
          this.in_process = false;
          this.message_in.id = id;
          this.message_in.type = control_command;
          this.message_in.address = data.substring(4); //HHHH AAAA
          this.message_in.length = 0;
          devices_instance.send_control(this.message_in);
        }
        break;

        case "BEE0": //configuration
        {
          this.message_in.message = data;
          //this.in_process = true;
          this.message_in.id = id;
          this.message_in.type = control_command;
          this.message_in.address = data.substring(4); //HHHH AAAA
          this.message_in.length = 0;
        }
        break;
      }
    }
    else if(this.in_process == true) //we still have
    {
      if(this.last_control)
      {
        this.last_control(data);
      }
      else
      {
        console.log("Last control failed badly!");
      }
    }
  }

  this.get_sub_type = function()
  {
    return this.message_in.sub_type;
  }

  this.process_message = function(data) //this will recontruct incoming data
  {
    if(this.message_in.length == 0) //we have a new message
    {
      var length = parseInt(data.substring(4,6), 16); //HHHH LL
      this.message_in.length = length;
      this.in_position = 0;

      this.message_in.message = data.substring(10); //this is the data

      if(this.message_in.length <= 17) //message is less than one ble packet long
      {
        this.in_process = false; //reset message in process
        devices_instance.send_control(this.message_in); //send to device --> page
        this.message_in.message = "";
      }
      else
      {
        this.last_control = this.process_message; //this should allow subsequent calls... it does
        this.in_position = 17;
      }
    }
    else if(this.in_position <= this.message_in.length) //we have not hit the end of the message yet
    {
      if(this.message_in.length - this.in_position >= 20) //full packet to assemble
      {
        this.message_in.message += data;
        this.in_position += 20; //actual string length is 40 (length is in hex EX. 0xFF <-- 2 chars)
      }
      else //we have a partial packet, and are at the end of message
      {
        this.message_in.message += data;
        this.in_process = false;
        devices_instance.send_control(this.message_in); //this routes back to the page "ble_control_message"
        this.message_in.message = "";
      }
    }
  }

  this.write_control = function(data, id, sub_type)
  {
    var control_command = data.substring(0, 4);
    var current_position = 0;
    var index = 0;
    var message = "";
    var packet = "";
    var data_length = "";

    switch(control_command)
    {
      case "BE03":
      { //HHHH AAAA
        data_length = pad(((data.length - 8) / 2).toString(16).toUpperCase(), 2);
        break;
      } //HHHH
      case "BE0B": //HHHH DDDD... This is for stuff with out address data
      {
        data_length = pad(((data.length - 4) / 2).toString(16).toUpperCase(), 2);
        break;
      } //No length -- may want to process sub_types in the future
      default:
      {
        data_length = "0"
        break;
      }
    }

    this.message_in.sub_type = sub_type; //this needs to be set to change subtype when the type of call changes

    if(data_length == "0")
    {
      message = control_command + data.substring(4);
      ble_client.write_wo_response(id, mod.service, mod.send, message); //send the first packet to ble device
      console.log("Write Control: " + message);
    }
    else //we are sending lots of data
    {
      message = control_command + data_length + data.substring(4);

      var convert = hexStringToByte(message); //convert string to byte array

      if(current_position == 0)
      {
        if(message.length > 40) //if more than a packet
        {
          current_position += 40;
          packet = message.substring(0, current_position);
        }
        else
        {
          packet = message;
          current_position = 40; //don't go in the while loop
        }

        ble_client.write_wo_response(id, mod.service, mod.send, packet); //send the first packet to ble device
        console.log("Write Control: " + packet);
      }

      control_command = control_command.substring(0,1) + 'A' +  control_command.substring(2); //immutable string BS: BE to BA
      index = (current_position - 6) / 2; //index is data to be written minus header, length (HHHH LL)

      while(current_position < message.length) //More than one packet add order byte
      { //HHHH II DD..
        packet = "" + control_command + pad(index.toString(16), 2).toUpperCase() + message.substring(current_position, current_position + 34);

        ble_client.write_wo_response(id, mod.service, mod.send, packet);
        console.log("Write Control: " + packet);

        if(current_position + 34 < message.length)
        {
          current_position += 34;
          index = (current_position - 6) / 2;
        }
        else
        {
          break;
        }
      }
    } //end length decision else
  }// end function

  this.set_rtcc = function(id)
  {
    var current_date = new Date(Date.now());
    var request = "BE0D01"; //this is the module command to set time
    var year;

    request += "" + pad(current_date.getSeconds(), 2) + pad(current_date.getMinutes(), 2) + pad(current_date.getHours(), 2);

    ble_client.write_wo_response(id, mod.service, mod.send, request); //set RTCC time
    console.log("Set Date: " + request);

    year = current_date.getFullYear().toString();
    request = "BE0D02" + pad(current_date.getDate(), 2) + pad((current_date.getMonth() + 1), 2)  + year.substring(2,4);
    console.log("Set Date: " + request);
    ble_client.write_wo_response(id, mod.service, mod.send, request); //set RTCC time
  }

  this.process_time = function(data)
  {
    var sub_command = data.substring(4,6);
    // BE CC 01 DD MM YY
    switch(sub_command)
    {
      case "04":
      {
        this.date.setSeconds(parseInt(data.substring(6,8)));
        this.date.setMinutes(parseInt(data.substring(8,10)));
        this.date.setHours(parseInt(data.substring(10,12)));
        break;
      }
      case "05":
      {
        this.date.setDate(parseInt(data.substring(6,8)));
        this.date.setMonth(parseInt(data.substring(8,10) - 1));
        this.date.setFullYear(parseInt("20" + data.substring(10,12)));
        break;
      }
    }
      console.log("Date Time: " + this.date)
  }

  // ********************* only for Classic ****************** //
  /*this.read_eeprom_pages = function(read_response, limit) //I moved this from classic page -- not ported yet!!!!!
  {
    var ee_request = "";
    var last_read_start = "";
    var address = 0;
    console.log("Count: " + this.count);

    if(this.count != 0)
    {
      last_read_start = read_response.message.substring(8, 12); //HHHH LL AAAA DDDDDD...
      address = (parseInt(read_response.address, 16) + 128); //next page address
    }
    else
    {
      address = parseInt(read_response.substring(6), 16); //start address
    }

    if(last_read_start == "BEE0")
    {
      this.last_read = last_read_start;
      console.log("Last read: " + this.last_read);
      //call process config
    }
    else if(address < limit) //This will walk through the eeprom
    {
      this.count++;
      ee_request = "BE0480" + pad(address.toString(16), 4).toUpperCase();
      self.ble_module.write_control(ee_request, self.instance.id, "BEE0");
      //console.log("Request: " + ee_request + " Count: " + this.count);
    }
    else
    {
      this.count = 0;
    }
  }

  this.write_eeprom_pages = function(write_response, limit) //for now this is for testing writing the whole eeprom
  {
    /BE03
    var last_write_start = "";
    var write_request = "";

    if(this.count != 0)
    {
      last_write_start = (parseInt(write_response.address, 16) + 128); //add 0x80 to the address for next write... this should be a number
      //console.log("EE_Write_Address: " + last_write_start);
    }
    else
    {
      last_write_start = parseInt(write_response.substring(4), 16);
    }

    var map = "";

    for(var i = 0; i < 122; i++)
    {
        map += "FF";//pad(i.toString(16), 2).toUpperCase();
    }

    if(last_write_start < limit) //This will walk through the eeprom to the limit amount
    {
      //last_write_start = 0x0000; //this is only to for testing write count;
      this.count++;self.transfer_data(self.device); //we start bulk data transfer here
      write_request = "BE03" + (pad((map.length / 2).toString(16), 2) + pad(last_write_start.toString(16), 4)).toUpperCase() + map;
      self.ble_module.write_control(write_request, self.instance.id, "BEE1");

      console.log(" Count: " + this.count);
    }
    else
    {
      this.count = 0;
    }
  } */
}
