var file_transfer = {
  //device
  device: "undefined",
  this_bus_id: "undefined",
  remote_bus_id: "undefined",
  variant: "undefined",
  spec: "undefined",
  //state info
  transfer_state: "slot_request_response",
  firmware: false,
  attempts: 0,
  watchdog_timeout: false,
  //file info
  filename: "",
  version: "undefined",
  number_of_blocks: "undefined",
  file_crc: "undefined",
  file_type: "undefined",
  file_byte_length: 0,
  //tranfer info
  file_block: "undefined",
  block_index: false,
  packet_threshold: 17,
  block_crc: "undefined",
  chunk_index: 0,
  last_offset: 0,
  file_offset: 0,
  block_offset: 0,
  send_block: "undefined",
  last_block: false,
  transfer_percent: 0,
  slot: "undefined",
  in_block: "false",
  in_transfer: 0,

  init: function(dev, this_bus_id_in, remote_bus_id_in, device_in, firmware)
  {
      if(file_transfer.in_transfer == false)
      {
        file_transfer.in_transfer = true;
      }

      //device's
      file_transfer.device = dev;
      file_transfer.this_bus_id = this_bus_id_in;
      file_transfer.remote_bus_id = pad(remote_bus_id_in, 2);
      file_transfer.device_type = device_in.device_type;
      file_transfer.variant = device_in.variant;
      file_transfer.variant_name = device_in.variant_name;
      file_transfer.spec = device_in.spec;

      //state info
      file_transfer.transfer_state = "slot_request_response"; //start state
      file_transfer.in_chunk = false;
      file_transfer.attempts = 0;
      file_transfer.watchdog_timeout = false;

      //file info
      file_transfer.firmware = firmware;
      file_transfer.version = "undefined";
      file_transfer.number_of_blocks = "undefined";
      file_transfer.file_crc ="undefined";
      file_transfer.file_type = "undefined";
      file_transfer.file_byte_length = 0;

      //transfer info
      file_transfer.file_block = "undefined";
      file_transfer.block_index = 0;
      file_transfer.block_crc = "undefined";
      file_transfer.chunk_index = 0;
      file_transfer.block_offset = 0;
      file_transfer.file_offset = 0;
      file_transfer.last_offset = 0;
      file_transfer.last_block = false;
      file_transfer.send_block = "undefined";
      file_transfer.slot = "0300";

      file_transfer.slot_request();
      show_modal();
  },

  write_frame: function(register, data_in, state)
  {
    return new Promise((resolve)=>{
      var data_out = data_in;
      var write_frame = canbus.construct_frame({serial_bits: "010", register: register, device_type: "07", index: "0", bus_id: file_transfer.remote_bus_id, dlc: (data_out.length / 2), data: data_out});

      file_transfer.transfer_state = state;

      ble_client.write_wo_response(file_transfer.device.id, spp.service, spp.tx, write_frame)
        .then(resolve());
    });
  },

  slot_request: function()
  {
    file_transfer.watchdog(3000);

    file_transfer.get_file_info()
      .then((result)=>{
        if(result)
        {
          var file_transfer_request = "";
          file_transfer_request = canbus.construct_frame({serial_bits: "010", register: "00C", device_type: "07", index: "0", bus_id: file_transfer.remote_bus_id, dlc: "5", data: file_transfer.slot + pad(file_transfer.this_bus_id, 2) + file_transfer.device_type + file_transfer.variant});

          console.log("FILE REQUEST: " + file_transfer_request + JSON.stringify(canbus.deconstruct_frame(file_transfer_request)));
          ble_client.write_wo_response(file_transfer.device.id, spp.service, spp.tx, file_transfer_request);

          update_modal("Requesting file slot");
          file_transfer.watchdog(3000);
          file_transfer.transfer_state = "slot_request_response";
        }
      });
  },

  receive_stream: function(message_in)
  {
    var message = message_in;

    switch(message.bus_id)
    {
      case file_transfer.this_bus_id:
        console.log("CLIENT DATA: " + JSON.stringify(message));
        file_transfer.process_client_data(message);
      break;

      case file_transfer.remote_bus_id:
        file_transfer.process_host_data(message);
      break;
    }
  },

  watchdog: function(timeout_in) //If time_in is 0, end watchdog -- file transfer complete?
  {
    clearTimeout(file_transfer.watchdog_timeout);
    var timeout = timeout_in;
     //gets cleared every call

    if(timeout != 0)
    {
      file_transfer.watchdog_timeout = setTimeout(()=>{ //if this gets called, file transfer ends.
        console.log("Watchdog!!!");
        hide_modal();
        cancelable_alert("Transfer timeout");
        ble_client.std_packet(file_transfer.device); //set to standard packet... no filter
        file_transfer.in_transfer = false;

      }, timeout);
    }
    else if (timeout == 0) //explicit end
    {
      hide_modal();
      ble_client.std_packet(file_transfer.device); //set to standard packet... no filter
      file_transfer.in_transfer = false;
    }
  },

  process_client_data: function(message_in)
  {
    var message = message_in;

    file_transfer.check_error(message)
      .then((message_checked)=>{

        if(message_checked.type != "error" && file_transfer.in_transfer != false)
        {
          switch(file_transfer.transfer_state)
          {
            case "slot_request_response":

                if(message.register == "00F")
                {
                  if(message.data == "FF01")
                  {
                    file_transfer.watchdog(3000);
                    update_modal("Slot request accepted");
                    console.log("SLOT REQUEST SUCCESSFUL ON: " + message.bus_id + " : " + message.data);

                    var data_out = ("FE" + file_transfer.device_key + file_transfer.number_of_blocks + pad(file_transfer.file_crc, 4)).toUpperCase();

                    file_transfer.write_frame("00F", data_out, "write_header_response");
                  }
                }
              break;

              case "write_header_response":

                file_transfer.watchdog(3000);

                console.log("Header_response: ", JSON.stringify(message));

                if(message.register == "00D" && message.data.length == 4)
                {
                  file_transfer.get_block_info();

                  file_transfer.write_frame("00F", "FD" + pad(file_transfer.block_index.toString(16), 4) + pad(file_transfer.block_crc, 4), "write_block")
                    .then(()=>{
                      var command_out = "write_block";

                      update_modal(file_transfer.transfer_percent + "% </br> " + "FIRMWARE: " + file_transfer.version + " Size: " + (file_transfer.file_byte_length / 1000) + "K </br>Block: " + file_transfer.block_index + " : " + pad(file_transfer.block_crc, 4));

                      file_transfer.process_client_data({register: command_out});
                  });
                }
              break;

              case "write_block":

              file_transfer.watchdog(5000);

              if(message.register == "00D")
              {
                if(message.data.substring(0, 6) == "FFFF00") //retransmit from 0xXXXX block
                {
                  if(!file_transfer.in_chunk)
                  {
                    file_transfer.in_chunk = true;
                    console.log("CHUNK FILTER ON");
                    //file_transfer.chunk_index = parseInt(message.data.substring(6, 10), 16);
                    file_transfer.file_offset = file_transfer.last_offset; //just resend block if chunk is corrupt
                    file_transfer.block_offset = file_transfer.file_offset;
                    file_transfer.chunk_index = 0;
                    //console.log("RECHUNK: " + file_transfer.chunk_index + " " + JSON.stringify(message));
                    update_modal("Error@chunk: " + file_transfer.chunk_index);
                    file_transfer.send_blocks(17);
                  }
                }
                else if(message.data.length == 4)
                {
                  var next_block = parseInt(message.data, 16);

                  if(file_transfer.in_chunk) //toggle in_chunk off if new block request is received
                  {
                    console.log("CHUNK FILTER OFF");
                    file_transfer.in_chunk = false;
                  }

                  console.log("Last block: " + file_transfer.block_index + " Next_block: " + next_block);

                  if(file_transfer.block_index == next_block) //reblock
                  {
                    file_transfer.file_offset = file_transfer.last_offset; //just resend block if chunk is corrupt
                    file_transfer.block_offset = file_transfer.file_offset;
                    file_transfer.chunk_index = 0;

                    file_transfer.get_block_info();

                    file_transfer.write_frame("00F", "FD" + pad(file_transfer.block_index.toString(16), 4) + pad(file_transfer.block_crc, 4), "write_block")
                      .then(()=>{
                        update_modal("Error@block: " + file_transfer.block_index);
                        file_transfer.send_blocks(17);
                      });
                  }
                  else if(next_block == file_transfer.block_index + 1) //normal block
                  {
                    file_transfer.block_index = next_block;
                    file_transfer.file_offset = file_transfer.block_index * 256;
                    file_transfer.last_offset = file_transfer.file_offset;
                    file_transfer.transfer_state = "write_header_response";
                    file_transfer.chunk_index = 0;

                    file_transfer.process_client_data(message);
                  }
                }
                else if(message.data.substring(0, 6) == "FFFF02")
                {
                  file_transfer.watchdog(5000); //extension for post processing
                  console.log("WATCHDOG: Post process extended 0xFFFF02")
                }
                else if(message.data.substring(0, 6) == "FFFF01")
                {
                  file_transfer.watchdog(0);

                  console.log("FILE TRANSFER COMPLETE: " + JSON.stringify(message.data));
                  hide_modal();

                  ble_client.std_packet(file_transfer.device)
                    .then(()=>{console.log("Connected... Setting LDMA packet size 244");});
                  file_transfer.in_transfer = false;

                  this.device.context.set_stream_location.call(this.device.context, "mngp2");

                  ons.notification.alert("File transfer complete.");
                  ble_client.disconnect(file_transfer.device);
                }
                else if(message.data == "FF" || message.data == "FE") //Final response check... ERROR STATE
                {
                  console.log("FILE TRANSFER FAILED: " + JSON.stringify(message.data));
                  hide_modal();
                  cancelable_alert("Failed: " + message.data);
                }
              }
              else if(message.register == "write_block") //write block
              {
                file_transfer.send_blocks(17);
              }
            break;
          }//end switch
        }//end error check condition
        else //get out of file transfer... ERROR
        {
          file_transfer.watchdog(0);

          ble_client.std_packet(file_transfer.device)
            .then(()=>{console.log("ERROR: " + message.data + "\n");
              hide_modal();
              cancelable_alert("Failed: " + message.data);
            file_transfer.in_transfer = false;

            var message_out = {type: "mngp2", }; //setup messages back to MNGP2
            this.device.context.receive_stream.call(this.device.context, message_out);
          });
        }
      });
  },

  get_block_info: function() //get next block information
  {
    if(parseInt(file_transfer.number_of_blocks, 16) > file_transfer.block_index + 1)
    {
      file_transfer.file_block = byteToHexString(file_transfer.firmware.slice(file_transfer.file_offset, file_transfer.file_offset + 256));
    }
    else if(parseInt(file_transfer.number_of_blocks, 16) == file_transfer.block_index + 1)
    {
      file_transfer.file_block = byteToHexString(file_transfer.firmware.slice(file_transfer.file_offset, file_transfer.file_offset + 256));
      file_transfer.last_block = true;
    }

    console.log("Block index: " + file_transfer.block_index);

    if(file_transfer.file_offset > file_transfer.last_offset) //increment block count
    {
      file_transfer.block_index++;
    }

    if(file_transfer.block_index != 0)
    {
      file_transfer.transfer_percent = (file_transfer.block_index  + 1) / parseInt(file_transfer.number_of_blocks, 16) * 100;

      file_transfer.transfer_percent = pad(file_transfer.transfer_percent.toString(), 2).substring(0,4);
    }

    file_transfer.block_crc = mod_crc(hexStringToByte(file_transfer.file_block)).toString(16).toUpperCase(); //block crc
  },

  send_blocks: function()
  {
    var length = 256;

    file_transfer.send_block= "";

    if(file_transfer.chunk_index != 0) //calculate write length based on chunk information
    {
      if(file_transfer.chunk_index == 37) //last chunk is 4 bytes of data
      {
        length = 4;
      }
      else
      {
        length = 256 - file_transfer.chunk_index * 7;
      }
    }

    file_transfer.create_packet(length)
      .then(()=>{
        var last_block = file_transfer.send_block;
        ble_client.write_wo_response(file_transfer.device.id, spp.service, spp.tx, file_transfer.send_block)
          .then((success)=>
          {
              if(!success)
              {
                update_modal("BT Write error");

                if(last_block != "")
                {
                  console.log("PACKET FAILED: " + file_transfer.send_block);
                  /*ble_client.write_wo_response(file_transfer.device.id, spp.service, spp.tx, last_block)
                    .then(()=>
                    {
                      file_transfer.calc_and_send();
                    });*/
                }
                else //kill update
                {
                  file_transfer.watchdog(0);
                }
              }
              else
              {
                file_transfer.calc_and_send();
              }
          });
      });
  },

  calc_and_send: function()
  {
    file_transfer.send_block = "";

    if((file_transfer.last_offset + 256) > file_transfer.block_offset)
    {
      file_transfer.send_blocks();
    }
    else
    {
      file_transfer.chunk_index = 0;
    }
  },

  create_packet: function(length)
  {
    return new Promise((resolve)=>
    {
      let i = 0;
      let chunk_offset = 0;

      while((file_transfer.packet_threshold > i) && file_transfer.chunk_index <= 36)
      {
        if((length - chunk_offset) > 7)  //maximum data length for full block packet
        {
          file_transfer.send_block += canbus.construct_frame({serial_bits: "010", register: "00F", device_type: "07", index: "0", bus_id: file_transfer.remote_bus_id, dlc: "8", data: pad(file_transfer.chunk_index.toString(16), 2) + pad(byteToHexString(file_transfer.firmware.slice(file_transfer.block_offset, (file_transfer.block_offset + 7), 14)))});
          file_transfer.block_offset += 7;
          file_transfer.chunk_index++;
          chunk_offset+=7;
        }
        else
        {
          var data_left = length - chunk_offset;

          file_transfer.send_block += canbus.construct_frame({serial_bits: "010", register: "00F", device_type: "07", index: "0", bus_id: file_transfer.remote_bus_id, dlc: (data_left + 1).toString(16), data: pad(file_transfer.chunk_index.toString(16), 2) + pad(byteToHexString(file_transfer.firmware.slice(file_transfer.block_offset, (file_transfer.block_offset + data_left), data_left * 2)))});

          file_transfer.block_offset += data_left;
          chunk_offset += data_left;
          file_transfer.chunk_index = 37;
        }
        i++;
      }
      resolve();
    });
  },

  get_file_info: function()
  {
    file_transfer.watchdog(3000);

    return new Promise((resolve)=>
    {
      if(file_transfer.firmware != undefined && file_transfer != false)
      {

        file_transfer.device_key = file_transfer.version = pad(byteToHexString(file_transfer.firmware.slice(0, 2)), 4);

        let major = parseInt(byteToHexString(file_transfer.firmware.slice(42, 43)), 16);
        let minor = parseInt(byteToHexString(file_transfer.firmware.slice(43, 44)), 16);
        let dev = parseInt(byteToHexString(file_transfer.firmware.slice(44, 45)), 16);
        let dev2 = parseInt(byteToHexString(file_transfer.firmware.slice(45, 46)), 16);

        file_transfer.version = pad(major, 2) + "." + pad(minor, 2) + "." + pad(dev, 2) + "." + pad(dev2, 2);

        file_transfer.number_of_blocks = pad(Math.ceil(file_transfer.firmware.length / 256).toString(16), 4).toUpperCase();

        file_transfer.file_byte_length = (parseInt(file_transfer.number_of_blocks, 16) - 1) * 256;

        var pad_len = 0;

        if((file_transfer.firmware.length % 256) != 0) //padded
        {
          pad_len = (file_transfer.firmware.length + (256 - (file_transfer.firmware.length % 256))) * 2;
        }
        else //on block limit
        {
          pad_len = file_transfer.firmware.length * 2;
        }

        console.log("FIRMWARE LENGTH: " + file_transfer.firmware.length + " " + "PAD LENGTH: " + pad_len / 2 - file_transfer.firmware.length);
        var padded = p_pad(byteToHexString(file_transfer.firmware), pad_len);

        file_transfer.firmware = hexStringToByte(padded);
        console.log("FILE LENGTH: " + file_transfer.firmware.length);
        file_transfer.file_crc = pad(mod_crc(hexStringToByte(padded), 4).toString(16)).toUpperCase(); //file_transfer.firmware).toString(16), 4);
        file_transfer.file_type = pad(byteToHexString(file_transfer.firmware.slice(12, 14)), 4);

        console.log("FILE INFO: Version: " + file_transfer.version + " num_blocks: " + pad(file_transfer.number_of_blocks.toString(16), 4) + " crc: " + file_transfer.file_crc + " file_type: " + file_transfer.file_type);

        resolve(true);
      }
      else
      {
        resolve(false);
      }
    });
  },

  check_error: function(message)
  {
    var message_in = message;

    return new Promise((resolve)=>{

      switch(message_in.register)
      {
        case "00D":

          let data_register = message_in.data.substring(4,6);

          if(data_register == "FE")
          {
            console.log("TRANSMISSION FAILED: " + JSON.stringify(message.data));
            message_in.type = "error";
            message_in.error = "TRANSMISSION FAILED: ";
            resolve(message_in);
          }
          else if(data_register == "FF")
          {
            console.log("CANCELLED TRANSACTION: " + JSON.stringify(message.data));
            message_in.type = "error";
            message_in.error = "CANCELLED TRANSACTION: ";
            resolve(message_in);
          }
          else
          {
            resolve(message_in);
          }

          break;

        case "00F":

          let block_register = message_in.data.substring(2, 4);

          if(block_register == "FE")
          {
            console.log("FILE IS WRITE ONLY: FF" + block_register);
            message_in.type = "error";
            message_in.error = "FILE IS WRITE ONLY: ";
            resolve(message_in);
          }
          else if(block_register == "FD")
          {
            console.log("FILE IS READ ONLY: FF" + block_register);
            message_in.type = "error";
            message_in.error = "FILE IS READ ONLY: ";
            resolve(message_in);
          }
          else if(block_register == "FB")
          {
            console.log("WRONG PACKAGE: FF" + block_register);
            message_in.type = "error";
            message_in.error = "FILE IS READ ONLY: ";
            resolve(message_in);
          }
          else if(block_register == "FC")
          {
            console.log("DEVICE IS BUSY: FF" + block_register);
            message_in.type = "error";
            message_in.error = "DEVICE IS BUSY: ";

            //maybe we can start over
            console.log("RESET TRANSFER");
            var reset_transfer = canbus.construct_frame({serial_bits: "010", register: "00F", device_type: "07", index: "0", bus_id: file_transfer.remote_bus_id, dlc: "1", data: "FF"});
            ble_client.write_wo_response(file_transfer.device.id, spp.service, spp.tx, reset_transfer);

            resolve(message_in);
          }
          else
          {
            resolve(message_in);
          }

        break;

        case "write_block":
          resolve(message_in);
        break;

      } //end switch
    }); //end promise
  },

  process_host_data: function(message_in)
  {
    //console.log("HOST: " + JSON.stringify(message_in));
  },

  response: {"": "Transfer aborted", "FF01": "Write request accepted", "FF00": "Transfer Complete", "FFFF": "File does not exist", "FFFE": "File is write only", "FFFD": "File is read only", "FFFC": "Device is busy"},
}
