function config(id)
{
  var self = this;
  this.config_id = id;
  this.config_obj = {id: id, set: false, settings: undefined};

  this.init = function()
  {
    //check for saved data
    return new Promise(function(resolve, reject)
    {
      NativeStorage.getItem(self.config_id, function(settings_in) //load saved from native storage
      {
        self.config_obj = settings_in;
        console.log("Loaded config");
        resolve("Loaded_config");
      },
      function()
      {
        NativeStorage.setItem(self.config_id, self.config_obj, function() //create new config 
        {
          console.log("Configuration not found. Setting Default.");
          resolve("Created_config");
        },
        function()
        {
          reject("Failed to create config!");
        });
      });
    });//end promise
  }

  this.remove_config = function() //resets to default
  {
    NativeStorage.remove(this.config_id, function()
    {
      console.log("Removed config data for: " + self.config_id);
    },
    function(e)
    {
      console("Failed to remove config for: " + JSON.stringify(e));
    });
  }

  this.set_settings = function(settings)
  {
    return new Promise(function(resolve, reject)
    {
      if(settings != undefined || settings != "")
      {
        self.config_obj.settings = settings;

        NativeStorage.setItem(self.config_id, self.config_obj, function() //We can write settings
        {
          //console.log("Wrote settings: " + JSON.stringify(self.config_obj));
          resolve(self.config_obj.settings);
        },
        function(e) //failed to create config
        {
          //console.log("Failed to write config: " + JSON.stringify(e));
          reject("write_settings_failed");
        });
      }
      else
      {
        console.log("Settings were empty. Something is not right. " + JSON.stringify(settings));
      }
    });
  }

  this.get_settings = function() //returns entire config
  {
    return this.config_obj.settings;
  }

  this.get_config = function()
  {
    return self;
  }
}
