function discovery(dev)
{
  var self = this;
  this.device = dev;
  this.device.context = self;
  this.count = 0;
  this.classic_interval = "undefined";
  this.discovered = false;
  this.speced = false;
  this.done = false;
  this.can_discovery_obj = "undefined";

  this.init = function()
  {
    switch(this.device.name)
    {
        case "MNGP2":
        {
          self.device.ser_id = self.device.id.replace(/:/g, "_"); //old conversion

          //update.add_device_to_list(self.device);
          scanner.scan_list_state_change(self.device, "advertising");

          ble.isConnected(self.device.id, function()
          {
            console.log("Device: " + self.device.id + " Already connected");
            ble.disconnect(self.device.id);
          },
          function() //if not connected
          {
            console.log("Device: " + self.device.id + " Discovery connecting");
            self.discovery_connect(self.device.id) //connect to discover
              .then(function(response)
              {
                scanner.scan_list_state_change(self.device, "connected");
                console.log("Connected to " + self.device.id);
                self.mngp2_discovery("get_info"); //do this because there are no devices to detect
              }, function(e)
              {
                  console.log("Discovery connect error: " + JSON.stringify(e));
              });
           });
        }
        break;

        case "OTA":
        {
          console.log("In OTA: " + self.device.id);
          self.device.ser_id = self.device.id.replace(/:/g, "_");
          this.discovery_add_device(self.device)
        }
        break;
     }
  }

  this.discovery_add_device = function(discovered)
  {
    if(devices_instance.exists(discovered) == false) //Check to see if we need to add to devices object
    {
      devices_instance.add_device(discovered)
        .then(function(result)
        {
          scanner.add_device_to_list(self.device); //if already discovered
        });
    }
    else
    {
      console.log("ADDING DEVICE TO SCANNER: " + self.device.name);
      scanner.add_device_to_list(self.device); //if not discovered
    }
  }

  this.discovery_connect = function(mac_id)
  {
    return new Promise(function(resolve)
    {
      ble.connect(mac_id, function() //bluetooth api function
      {
        resolve("connected");
      });
    });
  }

  this.extract_home = function()
  {
    let keys = Object.keys(this.devs_info);

    for(let i = 0; i < keys.length; i++)
    {
      if(this.devs_info[keys[i]].device_type == "14" && this.devs_info[keys[i]].hasOwnProperty("home"))
      {
        return this.device.dev_name = this.devs_info[keys[i]].dev_name;
      }
      else
      {
        this.device.dev_name = "undefined";
      }
    }
  }

  this.mngp2_discovery = function(state)
  {
    switch(state)
    {
     case "get_info":
        ble_client.start_notification(self.device.id, spp.service, spp.rx, "raw");
        self.device.context = self; //need this
        this.can_discovery_obj = new can_discovery(self.device);
        this.can_discovery_obj.init("14");
        scanner.scan_list_state_change(self.device, "discovering");
      break;

      case "speced":
        this.devs_info = this.can_discovery_obj.get_devices_discovered();
        ble.disconnect(self.device.id);
        scanner.scan_list_state_change(self.device, "advertising");
        this.extract_home();
        this.discovery_add_device(self.device);
        this.done = true;
      break;
    }
  }

  this.check_state = function()
  {
    return self.done;
  }

  this.receive_stream = function(message)
  {
    var message_in = message;

    switch(message_in.type)
    {
      case "discovery":
        if(message_in.sub_type == "listen_off")
        {
          console.log("DISCOVERY LISTEN OFF");
          this.mngp2_discovery("speced");
        }
      break;

      case "frame":
        this.can_discovery_obj.receive_stream(message_in);
      break;
    }
  }

  this.raw_in = function(data)
  {
    switch(self.device.name)
    {
      case "MNGP2":
        canbus.parse_canbus(data, self.device); //parses and sends decomposed to this.received_status
        //console.log("MNGP2 RAW: " + data);
      break;
    } //end Switch
  } //end Raw
}
