function logs(id)
{
  var self = this;
  this.logs_id = "logs_" + id;
  this.logs_obj = {day_set: {}};
  this.out_log = "";

  this.init = function()
  {
    //check for saved data
    NativeStorage.getItem(self.logs_id, function(logs_in) //load from native storage
    {
      if(logs_in == null)
      {
        NativeStorage.setItem(self.logs_id, self.logs_obj, function()
        {
          console.log("Setting new log set.");
        });
      }
      else //load log set
      {
        self.logs_obj = logs_in;
        console.log("Saved log set: " + JSON.stringify(self.logs_obj));
      }
    });
  }

  this.get_day_set = function()
  {
    return Object.keys(self.logs_obj.day_set);
  }

  this.get_day_log = function(day)
  {
    return new Promise(function(resolve, reject)
    {
      NativeStorage.getItem(self.logs_id + "_" + day, function(logs_in) //load from native storage
      {
        if(logs_in == null)
        {
          reject("does_not_exist");
        }
        else //load log set
        {
          self.out_log = logs_in;
          resolve(self.out_log);
        }
      });
    });
  }

  this.remove_log = function(log_ref) //resets to default
  {
    NativeStorage.remove(log_ref, function()
    {
      console.log("Removed log data for: " + log_ref);
    },
    function(e)
    {
      console("Failed to remove log data for: " + log_ref);
    });
  }

  this.set_day_log = function(log, day)
  {
    if(log != undefined || log != "")
    {
      if(!isSet(day)) //check to see if it is already set
      {
        NativeStorage.setItem(self.logs_id + "_" + day, log, function() //We can write settings
        {
          self.set_set(day);
          console.log("Wrote: Day " + day + " : " + JSON.stringify(log));
        },
        function(e) //failed to create config
        {
          console.log("Failed to write day log " + day);
        });
      }
    }
    else
    {
      console.log("Settings were empty. Something is not right.");
    }
  }

  function isSet(day) //returns if the set exists
  {
    if(self.logs_obj.day_set[day] == undefined)
    {
      console.log(day + " is not set");
      return false;
    }
    return true;
  }

  this.set_set = function(day)
  {
      this.logs_obj.day_set[day] = "";

      NativeStorage.setItem(self.logs_id, self.logs_obj, function() //We can write settings
      {
        console.log("Set set: " + day);
      },
      function(e) //failed to create config
      {
        console.log("Failed to set set: " + day);
      });
  }

  this.remove_logs = function()
  {
    var logs = this.get_day_set();

    for(var i = 0; i < logs.length; i++)
    {
      this.remove_log(self.logs_id + "_" + i);
    }
  }
};
