var scanner = {

  detected: "undefined",
  timeout: undefined,
  //retry: 0,
  advertising: [],
  interval: undefined,
  interval_period: 1000,
  type: "",
  input_event: "",
  init_once: false,

  init: function(type_in, input)
  {
    scanner.type = type_in;
    scanner.advertising = [];
    scanner.input_event = input;

    ble_client.check_ble_loc() //fire alerts and prompts user to turn on ble or location features
      .then((state)=>
      {
        if(state)
        {
          if(!scanner.init_once) //so we don't call add events more than once... this will eventually break events if too many (of the same) events are attached to this object
          {
            scanner.init_once = true;
            scanner.add_events();
          }

          show_modal();
          update_modal("Scanning...");

          if(scanner.type == "update")
          {
            ble_client.scan();
          }

          scanner.scan_timeout(7500);
        }
      });
  },

  reset: function()
  {
    scanner.init_once = false;
  },

  scan_timeout: function(duration)
  {
    scanner.timeout = setTimeout(function()
    {
      if(scanner.type == "update")
      {
        ble_client.stop_scan();
        update.init("single");
      }

      hide_modal();
    }, duration);
  },

  get_advertising: function()
  {
    return scanner.advertising;
  },

  get_scan_count: function()
  {
    return scanner.advertising.length;
  },

  add_device_to_list: function(device) //used to add devices to list
  {
    var dev = device;
    var list = $("#scan_list");

    if(device.name == "OTA" && ($("#scan_" + dev.ser_id).length > 0)) //update current device name to ota
    {
      $("#scan_" + dev.ser_id).html(dev.name + " " + dev.id);
    }

    if(/*devices_instance.exists(dev) == true &&*/ ($("#scan_" + dev.ser_id).length == 0)) //add device if it doesnt exist
    {
      if(scanner.nice_name(dev))
      {
        scanner.advertising.push({name: device.name, user_name: device.dev_name, ser_id: device.ser_id, id: device.id, state: "advertising", rssi: ""}); //there was a bug here that lasted a couple days involving user_name and device.name
      }
      else
      {
        scanner.advertising.push({name: device.name, ser_id: device.ser_id, id: device.id, state: "advertising", rssi: ""});
      }

      update_modal(dev.name + " : " + dev.id);

      let label = "";

      if(scanner.nice_name(dev)) //check to see if discovery has the nice name and change label on scanner button
      {
        label = dev.name + ": " + dev.id + "<br>"  + "<span style='font-size:.9em;'>" + dev.dev_name + "</span>";
      }
      else
      {
        label = dev.name + ": " + dev.id + "<br>";
      }

      switch(dev.name)
      {
        case "MNGP2":

          ons_createAttach("<ons-list-item class='list--noborder' modifier='nodivider'>\
          <img class='list-item__thumbnail' src='.\\img\\device_icons\\mngp2_b_w.png' style='padding-left:5vw;padding-right:3vw;'>\
          <div id='scan_" + dev.ser_id + "'>" + label + " </div><div id='scan_" + dev.ser_id + "_settings' class='right'></ons-list-item>", list);
          //<ons-icon icon='md-more-vert' size='2x' style='padding-right:5vw;'></ons-icon></div></ons-list-item>", list);
          list.append("<hr size='.5' width='90% align='center' noshade>");

        break;

        case "OTA":

          ons_createAttach("<ons-list-item class='list--noborder' modifier='nodivider'>\
          <div id='ota_" + dev.ser_id + "'>" + dev.name + " " + dev.id + " </div></ons-list-item>", list);
          list.append("<hr size='.5' width='90% align='center' noshade>");

        break;

      }//end switch

      scanner.add_click(list, dev);
    }
  },

  nice_name: function(device)
  {
    switch(device.name)
    {
      case "MNGP2":

        if(device.dev_name != undefined && device.dev_name != "undefined" && (device.dev_name != "MNGP2" || device.dev_name != "mngp2"))
        {
          return true;
        }
        else
        {
          return false;
        }

      break;
    }
  },

  check_duplicate: function(dev) //add flag for duplicate, and put device type from original on unknown OTA device
  {
    var keys = Object.keys(devices_instance.devices_obj);

    for(var i = 0; i < keys.length; i++)
    {
      if((devices_instance.devices_obj[keys[i]].id == dev.id && devices_instance.devices_obj[keys[i]].name) != "OTA")
      {
        dev.org_type = devices_instance.devices_obj[keys[i]].name; //added to ota device to remember type
      }
    }
  },

  add_click: function(list, device)
  {
    var dev = device;

    $('#scan_' + dev.ser_id).one('click', ()=>
    {
      /* In the event of "hardware backbutton", this needs to happen */
      $("#speed_dial").show();

      if(ble_client.check_scanning()) //stop scan so we don't continue discovery into the next life
      {
        ble_client.stop_scan();
      }

      devices_instance.reset_discovery();
      nav.load_page(dev);
      clearInterval(scanner.timeout);
      current_device = dev.id;
    });

    $('#scan_' + dev.ser_id + "_settings, #ota_" + dev.ser_id).on('click', ()=>
    {
      switch(dev.name)
      {
        case "MNGP2":

          settings_dialog.open_dialog(dev.ser_id, {type: "list", title: "Settings", loc: "landing_page", list:["BLE update"]})
          .then((message)=>{
            console.log("new_value: " + JSON.stringify(message));
            if(message.new_value == "BLE update")
            {
              update.fire_dialog(dev);
            }
          });

        break;

        case "OTA":

          update.fire_dialog(dev);

        break;
      }
    });
  },

  scan_list_state_change: function(dev, state) //connected, disconnected, disabled
  {
    if(dev.name == "MNGP2")
    {
      let dev_list = $("#scan_" + dev.ser_id);

      switch(state)
      {
        case 'rssi':
          dev_list.find(":nth-child(2)").html(state);
        break;

        case 'connected':
          dev_list.find("span:first").html(state);
        break;

        case 'disconnected':
          dev_list.find("span:first").html(state);
        break;

        case 'discovering':
          dev_list.find("span:first").html(state);
        break;

        case 'connecting':
          dev_list.find("span:first").html(state);
        break;

        case "advertising":
          dev_list.find("span:first").html(state);
        break;
      }
    }
  },

  check_connected: function() //populate list with devices already discovered
  {
    var keys = Object.keys(devices_instance.devices_obj);

    for(var i = 0; i < keys.length; i++)
    {
      if(devices_instance.devices_obj[keys[i]].hasOwnProperty("connected"))
      {
        if(devices_instance.devices_obj[keys[i]].connected)
        {
          console.log("Adding saved and connected devices");
          scanner.add_device_to_list(devices_instance.devices_obj[keys[i]]);
        }
      }
    }
  },

  add_events: function()
  {
    $("#" + scanner.input_event).on('click', ()=>
    {
      $("#scan_list").empty();

      if(ble_client.scanning == true)
      {
        console.log("Stopping Scan");
        ble_client.stop_scan()
          .then(()=>{
            ble_client.scan();
          });
      }
      else
      {
        console.log("Start scan");
        ble_client.scan();
      }
    });
  }//end add events
};
