var update_ui = {

    speed_dial: "undefined",
    view: "undefined",
    devices_box: "undefined",
    dev: "undefined",

    init: function(instance)
    {
      update_ui.dev = instance.device;
      show_modal();
      update_modal("Connecting");

      update_ui.speed_dial = $("#device_speed_dial");
      //ons_createAttach("<ons-speed-dial-item id='update_icon_" + instance.device.ser_id + "'><ons-icon icon='md-download'></ons-icon></ons-speed-dial-item>", update_ui.speed_dial);

      update_ui.view = $("#device_content"); //main

      $("#device_title").text("Devices");

      ons_createAttach("<div style='display:flex;flex-direction:row;justify-content:center;align-items:center;'><p id='ble_connection' style='display:inline'></p>\
      &nbsp<p style='display:inline' id='rssi_in'></p></div>", update_ui.view);

      update_ui.view.append("<div id='devices_box' style='display:flex;flex-direction:column;'></div>");
      update_ui.devices_box = $("#devices_box");
    },

    generate_device_card: function(b_dev) //parent device, bus device (CAN)
    {
      let min_dev = b_dev.uuid;
      console.log("UUID: " + min_dev);
      update_ui.devices_box.append("<div id='dev_view_min_" + min_dev + "'class='full_width' style='display:flex;flex-direction:row;justify-content:center;align-items:center;'></div>");

      var view = $("#dev_view_min_" + min_dev);

      //tmp = "FACTORY!!!";

      let variant = ""; //check for variant

      if(b_dev.hasOwnProperty("variant"))
      {
        if(b_dev.variant_name == "undefined")
        {
          variant = "Old";
        }
        else
        {
          variant = b_dev.variant_name.toUpperCase();
        }
      }

      let name = "";

      if(b_dev.hasOwnProperty("dev_name")) //check for valid device name
      {
        if(b_dev.dev_name != "undefined")
        {
          name = b_dev.dev_name;
        }
      }

      let version = "";

      if(b_dev.hasOwnProperty("dev_version")) //check for valid device name
      {
        if(b_dev.dev_version != "undefined")
        {
          version = b_dev.dev_version.toString();
          version = pad(version.substring(0,2), 2) + "." + pad(version.substring(2,4), 2) + "." + pad(version.substring(4,6), 2) + "." + pad(version.substring(6,8), 2);
        }
      }

      if(b_dev.hasOwnProperty("home")) //with home
      {
        if(b_dev.home != "")
        {
          ons_createAttach("<ons-card id='card_device_" + min_dev + "' class='two_third_w' style='flex-wrap:wrap;'><ons-icon icon='md-home'></ons-icon>\
          <p style='text-align:center'>" + "<br>" + canbus_map.device_types[b_dev.device_type] + " " + variant + " : " + b_dev.uuid.substring(4) + "<br>" + name + "<br>Version: " + version + "</br>" + update_ui.dev.id + "</p></ons-card>", view);
        }
      }
      else //normal
      {
        ons_createAttach("<ons-card id='card_device_" + min_dev + "' class='two_third_w' style='flex-wrap:wrap;'>\
        <p style='text-align:center'>" + "<br>" + canbus_map.device_types[b_dev.device_type] + " " + variant + " : " + min_dev.substring(4) + "<br>" + name + "<br>Version: " + version + "</p></ons-card>", view);
      }

      ons_createAttach("<ons-list id='list_device_" + min_dev + "' ></ons-list>", $("#card_device_" + min_dev));
    },

    update_device_card: function(message_in, def) //damn
    {
      //console.log("UI: " + JSON.stringify(message_in));

      if($("#list_device_" + message_in.uuid).length > 0) //if card exists
      {
        if($("#list_item_" + message_in.bus_id + "_" + message_in.register + "_" + "desc").length == 0)
        {
          ons_createAttach("<ons-list-header><div id='list_item_" + message_in.bus_id + "_" + message_in.register + "_" + "desc" + "' class='center_row'>" + message_in.data_out.desc + "\
          </div></ons-list-header>", $("#list_device_" + message_in.uuid));
        }

        let display = update_ui.get_display_values(message_in, def);

        for(let i = 0; i < display.length; i++)
        {
          if($("#list_item_" + display[i].id).length == 0) //if doesn't exist
          {
            ons_createAttach("<ons-list><div id='list_item_" + display[i].id + "' class='center_row' >" + display[i].display_value + "</div>\
            </ons-list>", $("#list_device_" + message_in.uuid));
          }
          else //populate
          {
            $("#list_item_" + display[i].id).html("" + display[i].display_value);
          }
        }
      }
    },

    get_display_values: function(message_in, def) //process this.device_process_reg (mngp_device) to get display data
    {
      var display = [];
      let counter = 0;

      for(let i = 0; i < message_in.data_out.values.length; i++)
      {
        if(def.display[i] != "") //only update values we want displayed
        {
          display.push({id: (message_in.bus_id + "_" + message_in.register + "_" + message_in.data_out.values[i].type), type: message_in.data_out.values[i].type, display_value: message_in.data_out.values[i].value}); //push new display object onto array with id

          if(def.meta.hasOwnProperty("fixed")) //get fixed decimal place value
          {
            if(def.meta.fixed[i] != "")
            {
              display[counter].display_value = display[counter].display_value.toFixed(def.meta.fixed[i]);
            }
          }

          if(def.meta.hasOwnProperty("pre"))
          {
              display[counter].display_value = def.meta.pre[i] + " " + display[counter].display_value;
          }

          if(def.meta.hasOwnProperty("post")) //add post name
          {
            display[counter].display_value = display[counter].display_value + def.meta.post[i];
          }

          counter++;
        }//end value criteria processing
      }//end loop

      return display;
    },

    update_rssi: function(rssi)
    {
      $("#rssi_in").text("RSSI: " + rssi);
    },

    file_transfer_device_reset: function()
    {
      ons.notification.confirm({messageHTML:'Transfer complete.<br>Would you like to apply the beta update?<br>(Selecting "Yes" will restart the unit)', buttonLabels: ["Yes", "No"], primaryButtonIndex: 0})
        .then((selection)=>
        {
          if(selection == 0)
          {
            file_transfer.send_reset();
          }
        });
    },

    update_connection: function(conn)
    {
      if(conn)
      {
        $("#ble_connection").text("Connnected");
      }
      else
      {
        $("#ble_connection").text("Disconnected");
      }
    }
}
